/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import org.apache.poi.xslf.model.CharacterPropertyFetcher;
import org.apache.poi.xslf.usermodel.TextCap;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFHyperlink;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STSchemeColorVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextUnderlineType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public class XSLFTextRun {
    private final CTRegularTextRun _r;
    private final XSLFTextParagraph _p;

    XSLFTextRun(CTRegularTextRun r, XSLFTextParagraph p) {
        this._r = r;
        this._p = p;
    }

    XSLFTextParagraph getParentParagraph() {
        return this._p;
    }

    public String getText() {
        return this._r.getT();
    }

    String getRenderableText() {
        String txt = this._r.getT();
        TextCap cap = this.getTextCap();
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == '\t') {
                buf.append("  ");
                continue;
            }
            switch (cap) {
                case ALL: {
                    buf.append(Character.toUpperCase(c));
                    continue block4;
                }
                case SMALL: {
                    buf.append(Character.toLowerCase(c));
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String tab2space() {
        AttributedString string = new AttributedString(" ");
        string.addAttribute(TextAttribute.FAMILY, this.getFontFamily());
        string.addAttribute(TextAttribute.SIZE, Float.valueOf((float)this.getFontSize()));
        TextLayout l = new TextLayout(string.getIterator(), new FontRenderContext(null, true, true));
        double wspace = l.getAdvance();
        double tabSz = this._p.getDefaultTabSize();
        int numSpaces = (int)Math.ceil(tabSz / wspace);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numSpaces; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void setText(String text) {
        this._r.setT(text);
    }

    public CTRegularTextRun getXmlObject() {
        return this._r;
    }

    public void setFontColor(Color color) {
        CTTextCharacterProperties rPr = this.getRPr();
        CTSolidColorFillProperties fill = rPr.isSetSolidFill() ? rPr.getSolidFill() : rPr.addNewSolidFill();
        CTSRgbColor clr = fill.isSetSrgbClr() ? fill.getSrgbClr() : fill.addNewSrgbClr();
        clr.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
        if (fill.isSetHslClr()) {
            fill.unsetHslClr();
        }
        if (fill.isSetPrstClr()) {
            fill.unsetPrstClr();
        }
        if (fill.isSetSchemeClr()) {
            fill.unsetSchemeClr();
        }
        if (fill.isSetScrgbClr()) {
            fill.unsetScrgbClr();
        }
        if (fill.isSetSysClr()) {
            fill.unsetSysClr();
        }
    }

    public Color getFontColor() {
        final XSLFTheme theme = this._p.getParentShape().getSheet().getTheme();
        CTShapeStyle style = this._p.getParentShape().getSpStyle();
        final CTSchemeColor phClr = style == null ? null : style.getFontRef().getSchemeClr();
        CharacterPropertyFetcher<Color> fetcher = new CharacterPropertyFetcher<Color>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                CTSolidColorFillProperties solidFill = props.getSolidFill();
                if (solidFill != null) {
                    boolean useCtxColor = solidFill.isSetSchemeClr() && solidFill.getSchemeClr().getVal() == STSchemeColorVal.PH_CLR || this.isFetchingFromMaster;
                    Color c = new XSLFColor((XmlObject)solidFill, theme, useCtxColor ? phClr : null).getColor();
                    this.setValue(c);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return (Color)fetcher.getValue();
    }

    public void setFontSize(double fontSize) {
        CTTextCharacterProperties rPr = this.getRPr();
        if (fontSize == -1.0) {
            if (rPr.isSetSz()) {
                rPr.unsetSz();
            }
        } else {
            if (fontSize < 1.0) {
                throw new IllegalArgumentException("Minimum font size is 1pt but was " + fontSize);
            }
            rPr.setSz((int)(100.0 * fontSize));
        }
    }

    public double getFontSize() {
        double scale = 1.0;
        CTTextNormalAutofit afit = this.getParentParagraph().getParentShape().getTextBodyPr().getNormAutofit();
        if (afit != null) {
            scale = (double)afit.getFontScale() / 100000.0;
        }
        CharacterPropertyFetcher<Double> fetcher = new CharacterPropertyFetcher<Double>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetSz()) {
                    this.setValue((double)props.getSz() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? -1.0 : (Double)fetcher.getValue() * scale;
    }

    public double getCharacterSpacing() {
        CharacterPropertyFetcher<Double> fetcher = new CharacterPropertyFetcher<Double>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetSpc()) {
                    this.setValue((double)props.getSpc() * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setCharacterSpacing(double spc) {
        CTTextCharacterProperties rPr = this.getRPr();
        if (spc == 0.0) {
            if (rPr.isSetSpc()) {
                rPr.unsetSpc();
            }
        } else {
            rPr.setSpc((int)(100.0 * spc));
        }
    }

    public void setFontFamily(String typeface) {
        this.setFontFamily(typeface, (byte)-1, (byte)-1, false);
    }

    public void setFontFamily(String typeface, byte charset, byte pictAndFamily, boolean isSymbol) {
        CTTextCharacterProperties rPr = this.getRPr();
        if (typeface == null) {
            if (rPr.isSetLatin()) {
                rPr.unsetLatin();
            }
            if (rPr.isSetCs()) {
                rPr.unsetCs();
            }
            if (rPr.isSetSym()) {
                rPr.unsetSym();
            }
        } else if (isSymbol) {
            CTTextFont font = rPr.isSetSym() ? rPr.getSym() : rPr.addNewSym();
            font.setTypeface(typeface);
        } else {
            CTTextFont latin = rPr.isSetLatin() ? rPr.getLatin() : rPr.addNewLatin();
            latin.setTypeface(typeface);
            if (charset != -1) {
                latin.setCharset(charset);
            }
            if (pictAndFamily != -1) {
                latin.setPitchFamily(pictAndFamily);
            }
        }
    }

    public String getFontFamily() {
        final XSLFTheme theme = this._p.getParentShape().getSheet().getTheme();
        CharacterPropertyFetcher<String> visitor = new CharacterPropertyFetcher<String>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                CTTextFont font = props.getLatin();
                if (font != null) {
                    String typeface = font.getTypeface();
                    if ("+mj-lt".equals(typeface)) {
                        typeface = theme.getMajorFont();
                    } else if ("+mn-lt".equals(typeface)) {
                        typeface = theme.getMinorFont();
                    }
                    this.setValue(typeface);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(visitor);
        return (String)visitor.getValue();
    }

    public byte getPitchAndFamily() {
        XSLFTheme theme = this._p.getParentShape().getSheet().getTheme();
        CharacterPropertyFetcher<Byte> visitor = new CharacterPropertyFetcher<Byte>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                CTTextFont font = props.getLatin();
                if (font != null) {
                    this.setValue(font.getPitchFamily());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(visitor);
        return visitor.getValue() == null ? (byte)0 : (Byte)visitor.getValue();
    }

    public void setStrikethrough(boolean strike) {
        this.getRPr().setStrike(strike ? STTextStrikeType.SNG_STRIKE : STTextStrikeType.NO_STRIKE);
    }

    public boolean isStrikethrough() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetStrike()) {
                    this.setValue(props.getStrike() != STTextStrikeType.NO_STRIKE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public boolean isSuperscript() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetBaseline()) {
                    this.setValue(props.getBaseline() > 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setBaselineOffset(double baselineOffset) {
        this.getRPr().setBaseline((int)baselineOffset * 1000);
    }

    public void setSuperscript(boolean flag) {
        this.setBaselineOffset(flag ? 30.0 : 0.0);
    }

    public void setSubscript(boolean flag) {
        this.setBaselineOffset(flag ? -25.0 : 0.0);
    }

    public boolean isSubscript() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetBaseline()) {
                    this.setValue(props.getBaseline() < 0);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public TextCap getTextCap() {
        CharacterPropertyFetcher<TextCap> fetcher = new CharacterPropertyFetcher<TextCap>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetCap()) {
                    int idx = props.getCap().intValue() - 1;
                    this.setValue(TextCap.values()[idx]);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? TextCap.NONE : (TextCap)((Object)fetcher.getValue());
    }

    public void setBold(boolean bold) {
        this.getRPr().setB(bold);
    }

    public boolean isBold() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetB()) {
                    this.setValue(props.getB());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setItalic(boolean italic) {
        this.getRPr().setI(italic);
    }

    public boolean isItalic() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetI()) {
                    this.setValue(props.getI());
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setUnderline(boolean underline) {
        this.getRPr().setU(underline ? STTextUnderlineType.SNG : STTextUnderlineType.NONE);
    }

    public boolean isUnderline() {
        CharacterPropertyFetcher<Boolean> fetcher = new CharacterPropertyFetcher<Boolean>(this._p.getLevel()){

            @Override
            public boolean fetch(CTTextCharacterProperties props) {
                if (props.isSetU()) {
                    this.setValue(props.getU() != STTextUnderlineType.NONE);
                    return true;
                }
                return false;
            }
        };
        this.fetchCharacterProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    protected CTTextCharacterProperties getRPr() {
        return this._r.isSetRPr() ? this._r.getRPr() : this._r.addNewRPr();
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    public XSLFHyperlink createHyperlink() {
        XSLFHyperlink link = new XSLFHyperlink(this._r.getRPr().addNewHlinkClick(), this);
        return link;
    }

    public XSLFHyperlink getHyperlink() {
        if (!this._r.getRPr().isSetHlinkClick()) {
            return null;
        }
        return new XSLFHyperlink(this._r.getRPr().getHlinkClick(), this);
    }

    private boolean fetchCharacterProperty(CharacterPropertyFetcher fetcher) {
        XSLFTextShape shape;
        boolean ok = false;
        if (this._r.isSetRPr()) {
            ok = fetcher.fetch(this.getRPr());
        }
        if (!ok && !(ok = (shape = this._p.getParentShape()).fetchShapeProperty(fetcher))) {
            CTTextParagraphProperties defaultProps;
            XMLSlideShow ppt;
            CTTextParagraphProperties themeProps;
            CTPlaceholder ph = shape.getCTPlaceholder();
            if (ph == null && (themeProps = (ppt = shape.getSheet().getSlideShow()).getDefaultParagraphStyle(this._p.getLevel())) != null) {
                fetcher.isFetchingFromMaster = true;
                ok = fetcher.fetch(themeProps);
            }
            if (!ok && (defaultProps = this._p.getDefaultMasterStyle()) != null) {
                fetcher.isFetchingFromMaster = true;
                ok = fetcher.fetch(defaultProps);
            }
        }
        return ok;
    }

    void copy(XSLFTextRun r) {
        boolean strike;
        boolean underline;
        boolean italic;
        boolean bold;
        double srcFontSize;
        Color srcFontColor;
        String srcFontFamily = r.getFontFamily();
        if (srcFontFamily != null && !srcFontFamily.equals(this.getFontFamily())) {
            this.setFontFamily(srcFontFamily);
        }
        if ((srcFontColor = r.getFontColor()) != null && !srcFontColor.equals(this.getFontColor())) {
            this.setFontColor(srcFontColor);
        }
        if ((srcFontSize = r.getFontSize()) != this.getFontSize()) {
            this.setFontSize(srcFontSize);
        }
        if ((bold = r.isBold()) != this.isBold()) {
            this.setBold(bold);
        }
        if ((italic = r.isItalic()) != this.isItalic()) {
            this.setItalic(italic);
        }
        if ((underline = r.isUnderline()) != this.isUnderline()) {
            this.setUnderline(underline);
        }
        if ((strike = r.isStrikethrough()) != this.isStrikethrough()) {
            this.setStrikethrough(strike);
        }
    }
}

