/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.VersionMatchRule;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionUtil {
    public static final Comparator<IPluginModelBase> BY_DESCENDING_PLUGIN_VERSION = Comparator.comparing(VersionUtil::getVersion).reversed();

    private VersionUtil() {
    }

    public static IStatus validateVersion(String versionString) {
        try {
            if (versionString != null) {
                new Version(versionString.trim());
            }
        }
        catch (IllegalArgumentException e) {
            return Status.error((String)UtilMessages.BundleErrorReporter_InvalidFormatInBundleVersion, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateVersionRange(String versionRangeString) {
        try {
            if (versionRangeString != null) {
                new VersionRange(versionRangeString);
            }
        }
        catch (IllegalArgumentException e) {
            return Status.error((String)UtilMessages.BundleErrorReporter_invalidVersionRangeFormat, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static Version getVersion(IPluginModelBase model) {
        String version = model.getPluginBase().getVersion();
        try {
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Version.emptyVersion;
        }
    }

    public static VersionMatchRule matchRuleFromLiteral(int literal) {
        return switch (literal) {
            case 1 -> VersionMatchRule.EQUIVALENT;
            case 0, 2 -> VersionMatchRule.COMPATIBLE;
            case 3 -> VersionMatchRule.PERFECT;
            case 4 -> VersionMatchRule.GREATER_OR_EQUAL;
            default -> throw new IllegalArgumentException("Unsupported match rule literal: " + literal);
        };
    }

    public static boolean compare(String version1, String version2, int match) {
        try {
            Version v1 = Version.parseVersion((String)version1);
            Version v2 = Version.parseVersion((String)version2);
            return VersionUtil.matchRuleFromLiteral(match).matches(v1, v2);
        }
        catch (RuntimeException runtimeException) {
            return version1.equals(version2);
        }
    }

    public static boolean isEmptyVersion(String version) {
        if (version == null) {
            return true;
        }
        return (version = version.trim()).length() == 0 || version.equals(Version.emptyVersion.toString());
    }

    public static int compareMacroMinorMicro(Version v1, Version v2) {
        int result = v1.getMajor() - v2.getMajor();
        if (result != 0) {
            return result;
        }
        result = v1.getMinor() - v2.getMinor();
        if (result != 0) {
            return result;
        }
        result = v1.getMicro() - v2.getMicro();
        return result;
    }

    public static String computeInitialPluginVersion(String version) {
        if (version != null && VersionUtil.validateVersion(version).isOK()) {
            Version pvi = Version.parseVersion((String)version);
            return pvi.getMajor() + "." + pvi.getMinor() + "." + pvi.getMicro();
        }
        return version;
    }
}

