/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnit3TestFinder;
import org.eclipse.jdt.internal.junit.launcher.JUnit4TestFinder;
import org.eclipse.jdt.internal.junit.launcher.JUnit5TestFinder;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SuiteClassesContentProvider
implements IStructuredContentProvider {
    private boolean fIncludeJunit4Tests;
    private boolean fIncludeJunit5Tests;

    public SuiteClassesContentProvider() {
        this(false, false);
    }

    public SuiteClassesContentProvider(boolean includeJunit4Tests, boolean includeJunit5Tests) {
        this.fIncludeJunit4Tests = includeJunit4Tests;
        this.fIncludeJunit5Tests = includeJunit5Tests;
    }

    public Object[] getElements(Object parent) {
        if (!(parent instanceof IPackageFragment)) {
            return new Object[0];
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (!pack.exists()) {
            return new Object[0];
        }
        Set<IType> tests = this.getTests(pack);
        Object[] result = tests.toArray(new IType[tests.size()]);
        Arrays.sort(result, new Comparator<IType>(){
            private Collator fCollator = Collator.getInstance();

            @Override
            public int compare(IType t1, IType t2) {
                return this.fCollator.compare(t1.getElementName(), t2.getElementName());
            }
        });
        return result;
    }

    public Set<IType> getTests(IPackageFragment pack) {
        try {
            HashSet<IType> result = new HashSet<IType>();
            if (this.isIncludeJunit5Tests()) {
                new JUnit5TestFinder().findTestsInContainer((IJavaElement)pack, result, null);
            } else if (this.isIncludeJunit4Tests()) {
                new JUnit4TestFinder().findTestsInContainer((IJavaElement)pack, result, null);
            } else {
                new JUnit3TestFinder().findTestsInContainer((IJavaElement)pack, result, null);
            }
            return result;
        }
        catch (CoreException e) {
            JUnitPlugin.log(e);
            return Collections.emptySet();
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setIncludeJunit4Tests(boolean includeJunit4Tests) {
        this.fIncludeJunit4Tests = includeJunit4Tests;
    }

    public boolean isIncludeJunit4Tests() {
        return this.fIncludeJunit4Tests;
    }

    public void setIncludeJunit5Tests(boolean includeJunit5Tests) {
        this.fIncludeJunit5Tests = includeJunit5Tests;
    }

    public boolean isIncludeJunit5Tests() {
        return this.fIncludeJunit5Tests;
    }
}

