/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.rcptt.ui.utils.TreeViewerWildcardFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectTagDialog
extends TrayDialog {
    private final List<Tag> result = new ArrayList<Tag>();
    private final List<String> disabledTags;
    protected String tagName;
    private static final String SETTINGS_KEY = "SelectTagDialog";
    private ObservableList allTags;

    public SelectTagDialog(Shell parentShell, List<String> disabledTags) {
        super(parentShell);
        Assert.isNotNull((Object)parentShell, (String)"parentShell");
        Assert.isNotNull(disabledTags, (String)"disabledTags");
        this.disabledTags = disabledTags;
        this.setShellStyle(66768);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Control createDialogArea(Composite parent) {
        TagsRegistry tagRegistry;
        Composite panel = (Composite)super.createDialogArea(parent);
        final SearchControl searchControl = new SearchControl(panel);
        searchControl.setInitialText(Messages.SelectTagDialog_InitialTagName);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchControl);
        final TreeViewer tagsViewer = new TreeViewer(panel, 2050);
        tagsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        searchControl.setSearchResultControl(tagsViewer.getControl());
        searchControl.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = searchControl.getFilterString();
                SelectTagDialog.this.tagName = !searchControl.getInitialText().equals(value) ? value : null;
                tagsViewer.refresh();
                SelectTagDialog.this.validate();
            }
        });
        tagsViewer.setFilters(new ViewerFilter[]{new TreeViewerWildcardFilter(tagsViewer){

            @Override
            protected boolean isIgnoredElement(Object parentElement, Object element) {
                return false;
            }

            @Override
            protected String getFilterText() {
                String value = searchControl.getFilterString();
                if (!searchControl.getInitialText().equals(value)) {
                    return value;
                }
                return "";
            }

            @Override
            protected String getElementText(Object parentElement, Object element) {
                return ((Tag)element).getValue();
            }
        }});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(new IObservableFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof Tag) {
                    Tag tag = (Tag)target;
                    WritableList list = new WritableList();
                    Tag tag2 = tag;
                    synchronized (tag2) {
                        EList tags = tag.getTags();
                        Iterator iterator = tags.iterator();
                        while (iterator.hasNext()) {
                            Tag childTag;
                            Tag tag3 = childTag = (Tag)iterator.next();
                            synchronized (tag3) {
                                if (childTag.getTags().size() > 0 || !SelectTagDialog.this.disabledTags.contains(childTag.getPath())) {
                                    list.add((Object)childTag);
                                }
                            }
                        }
                    }
                    return list;
                }
                return null;
            }
        }, null);
        tagsViewer.setContentProvider((IContentProvider)contentProvider);
        this.allTags = new WritableList();
        TagsRegistry tagsRegistry = tagRegistry = Q7UIPlugin.getDefault().getTags();
        synchronized (tagsRegistry) {
            EList tags = tagRegistry.getTags();
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                Tag childTag;
                Tag tag = childTag = (Tag)iterator.next();
                synchronized (tag) {
                    if (childTag.getTags().size() > 0 || !this.disabledTags.contains(childTag.getPath())) {
                        this.allTags.add((Object)childTag);
                    }
                }
            }
        }
        tagsViewer.setInput((Object)this.allTags);
        tagsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TagLabels()));
        tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                SelectTagDialog.this.result.clear();
                boolean changed = false;
                for (Object o : iss.toList()) {
                    Tag tag = (Tag)o;
                    if (!SelectTagDialog.this.disabledTags.contains(tag.getPath())) {
                        SelectTagDialog.this.result.add(tag);
                        continue;
                    }
                    changed = true;
                }
                if (changed) {
                    tagsViewer.setSelection((ISelection)new StructuredSelection(SelectTagDialog.this.result));
                }
                SelectTagDialog.this.validate();
            }
        });
        tagsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectTagDialog.this.setReturnCode(0);
                SelectTagDialog.this.result.clear();
                SelectTagDialog.this.result.add((Tag)((IStructuredSelection)event.getSelection()).getFirstElement());
                SelectTagDialog.this.close();
            }
        });
        this.validate();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)panel, "org.eclipse.rcptt.help.q7_tags");
        return panel;
    }

    protected void validate() {
        Button button = this.getButton(0);
        if (button != null) {
            if (!this.result.isEmpty() || this.tagName != null && this.tagName.trim().length() > 0) {
                if (!this.disabledTags.contains(this.tagName)) {
                    button.setEnabled(true);
                }
            } else {
                button.setEnabled(false);
            }
        }
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.result.clear();
        this.close();
    }

    public List<Tag> getResult() {
        return this.result;
    }

    public String getTagName() {
        return this.tagName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectTagDialog_Title);
        newShell.setImage(Images.getImageDescriptor("icons/tag.gif").createImage());
        newShell.layout(true);
    }

    public int open() {
        this.result.clear();
        return super.open();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }

    protected Point getInitialSize() {
        Point calculatedSize = super.getInitialSize();
        if (calculatedSize.x < 500) {
            calculatedSize.x = 500;
        }
        if (calculatedSize.y < 400) {
            calculatedSize.y = 400;
        }
        return calculatedSize;
    }

    private class TagLabels
    extends LabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IBaseLabelProvider {
        private TagLabels() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Tag tag = (Tag)element;
            int size = TagsUtil.getDistinctTagRefsCount((Tag)tag);
            if (size == 1) {
                return Messages.bind((String)Messages.SelectTagDialog_TagWithOneOccurrenceFormat, (Object)tag.getValue());
            }
            return Messages.bind((String)Messages.SelectTagDialog_TagWithManyOccurrencesFormat, (Object)tag.getValue(), (Object)size);
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            StyledString ss = new StyledString();
            Tag tag = (Tag)element;
            int size = TagsUtil.getDistinctTagRefsCount((Tag)tag);
            if (size == 1) {
                ss.append(Messages.bind((String)Messages.SelectTagDialog_TagWithOneOccurrenceFormat, (Object)tag.getValue()));
            } else {
                ss.append(Messages.bind((String)Messages.SelectTagDialog_TagWithManyOccurrencesFormat, (Object)tag.getValue(), (Object)size));
            }
            int pos = tag.getValue().length();
            ss.setStyle(pos, ss.length() - pos, new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.foreground = SelectTagDialog.this.getShell().getDisplay().getSystemColor(15);
                }
            });
            return ss;
        }
    }
}

