/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AbstractMethodCorrectionProposalCore;

public class NewDefiningMethodProposalCore
extends AbstractMethodCorrectionProposalCore {
    private final IMethodBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposalCore(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, IMethodBinding method, String[] paramNames, int relevance) {
        super(label, targetCU, invocationNode, binding, relevance);
        this.fMethod = method;
        this.fParamNames = paramNames;
    }

    @Override
    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    @Override
    protected void addNewParameters(ASTRewrite rewrite, List<String> takenNames, List<SingleVariableDeclaration> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        this.getInvocationNode();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getParameterTypes();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[][] paramNames = StubUtility.suggestArgumentNamesWithProposals(project, this.fParamNames);
        int i = 0;
        while (i < bindings.length) {
            ITypeBinding curr = bindings[i];
            String[] proposedNames = paramNames[i];
            SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
            newParam.setType(importRewrite.addImport(curr, ast, context, ImportRewrite.TypeLocation.PARAMETER));
            newParam.setName(ast.newSimpleName(proposedNames[0]));
            params.add(newParam);
            String groupId = "arg_name_" + i;
            this.addLinkedPosition(rewrite.track((ASTNode)newParam.getName()), false, groupId);
            String[] stringArray = proposedNames;
            int n = proposedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String proposedName = stringArray[n2];
                this.addLinkedPositionProposal(groupId, proposedName);
                ++n2;
            }
            ++i;
        }
        if (params.isEmpty() || bindings.length == 0) {
            return;
        }
        if (this.fMethod.isVarargs()) {
            SingleVariableDeclaration singleVariableDeclaration = params.get(bindings.length - 1);
            singleVariableDeclaration.setVarargs(true);
            Type type = singleVariableDeclaration.getType();
            if (type != null && type.isArrayType()) {
                List dimensions = ((ArrayType)type).dimensions();
                if (dimensions.isEmpty()) {
                    return;
                }
                dimensions.remove(dimensions.size() - 1);
            }
        }
    }

    @Override
    protected void addNewJavaDoc(ASTRewrite rewrite, MethodDeclaration decl) throws CoreException {
        String newJavadocString;
        Javadoc oldJavadoc = ((MethodDeclaration)ASTNodes.findDeclaration((IBinding)this.fMethod, this.getInvocationNode())).getJavadoc();
        if (oldJavadoc != null && (newJavadocString = ASTNodes.getNodeSource((ASTNode)oldJavadoc, false, true)) != null) {
            decl.setJavadoc((Javadoc)rewrite.createStringPlaceholder(newJavadocString, 29));
        }
    }

    @Override
    protected SimpleName getNewName(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleName nameNode = ast.newSimpleName(this.fMethod.getName());
        return nameNode;
    }

    private int evaluateModifiers() {
        if (this.getSenderBinding().isInterface()) {
            return 0;
        }
        int modifiers = this.fMethod.getModifiers();
        if (Modifier.isPrivate((int)modifiers)) {
            modifiers |= 4;
        }
        return modifiers & 0xC05;
    }

    @Override
    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List<IExtendedModifier> modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers()));
    }

    @Override
    protected Type getNewMethodType(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext context) throws CoreException {
        return this.getImportRewrite().addImport(this.fMethod.getReturnType(), rewrite.getAST(), context, ImportRewrite.TypeLocation.RETURN_TYPE);
    }

    @Override
    protected void addNewExceptions(ASTRewrite rewrite, List<Type> exceptions, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] bindings = this.fMethod.getExceptionTypes();
        int i = 0;
        while (i < bindings.length) {
            Type newType = importRewrite.addImport(bindings[i], ast, context, ImportRewrite.TypeLocation.EXCEPTION);
            exceptions.add(newType);
            this.addLinkedPosition(rewrite.track((ASTNode)newType), false, "exc_type_" + i);
            ++i;
        }
    }

    @Override
    protected void addNewTypeParameters(ASTRewrite rewrite, List<String> takenNames, List<TypeParameter> typeParameters, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        ITypeBinding[] iTypeBindingArray = this.fMethod.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding current = iTypeBindingArray[n2];
            TypeParameter newTypeParameter = ast.newTypeParameter();
            newTypeParameter.setName(ast.newSimpleName(current.getName()));
            ITypeBinding[] typeBounds = current.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParameter.typeBounds();
                ITypeBinding[] iTypeBindingArray2 = typeBounds;
                int n3 = typeBounds.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding typeBound = iTypeBindingArray2[n4];
                    newTypeBounds.add(this.getImportRewrite().addImport(typeBound, ast, context, ImportRewrite.TypeLocation.TYPE_BOUND));
                    ++n4;
                }
            }
            typeParameters.add(newTypeParameter);
            ++n2;
        }
    }
}

