/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Operation;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDelta;

public class DiscardWorkingCopyOperation
extends Q7Operation {
    private boolean indexing;

    public DiscardWorkingCopyOperation(IQ7NamedElement workingCopy, boolean indexing) {
        super(new IQ7Element[]{workingCopy});
        this.indexing = indexing;
    }

    @Override
    protected void executeOperation() throws ModelException, InterruptedException {
        Q7NamedElement workingCopy = this.getNamedElement();
        ModelManager manager = ModelManager.getModelManager();
        int useCount = manager.discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            if (workingCopy.getResource().isAccessible()) {
                if (!this.indexing) {
                    Q7ElementDelta delta = new Q7ElementDelta(this.getModel());
                    delta.changed(workingCopy, 65536);
                    this.addDelta(delta);
                }
            } else if (!this.indexing) {
                Q7ElementDelta delta = new Q7ElementDelta(this.getModel());
                delta.removed(workingCopy, 65536);
                this.addDelta(delta);
            }
        }
    }

    protected Q7NamedElement getNamedElement() {
        return (Q7NamedElement)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

