/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;

public final class PartStackUtil {
    private static final String PRIMARY_DATA_STACK_ID = "org.eclipse.e4.primaryDataStack";
    public static final String EDITOR_STACK_TAG = "EditorStack";

    private PartStackUtil() {
    }

    public static void initializeAsPrimaryDataStack(MPartStack partStack) {
        PartStackUtil.makeEditorStack(partStack);
        partStack.getTags().add(PRIMARY_DATA_STACK_ID);
        partStack.setElementId(PRIMARY_DATA_STACK_ID);
    }

    public static boolean isPrimaryDataStack(MApplicationElement element) {
        return element instanceof MPartStack && PRIMARY_DATA_STACK_ID.equals(element.getElementId());
    }

    public static boolean isEditorStack(MApplicationElement element) {
        return element instanceof MPartStack && element.getTags().contains(EDITOR_STACK_TAG);
    }

    public static void makeEditorStack(MPartStack partStack) {
        if (!partStack.getTags().contains(EDITOR_STACK_TAG)) {
            partStack.getTags().add(EDITOR_STACK_TAG);
        }
    }
}

