/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import aQute.bnd.build.Workspace;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocation;
import org.eclipse.pde.internal.ui.bndtools.BndTargetLocationFactory;
import org.eclipse.pde.internal.ui.bndtools.RepositoryTargetLocationWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepositoryTargetLocation
extends BndTargetLocation {
    static final String TYPE = "BndRepositoryLocation";
    static final String MESSAGE_UNABLE_TO_RESOLVE_REPOSITORIES = "Unable to resolve Bnd repository plugins";
    static final String ELEMENT_REPOSITORY = "repository";
    static final String ATTRIBUTE_REPOSITORY_NAME = "name";
    private String repositoryName;
    private RepositoryPlugin repository;

    public RepositoryTargetLocation() {
        super(TYPE, "database.svg");
    }

    public RepositoryTargetLocation setRepository(String repositoryName) {
        this.repositoryName = repositoryName;
        this.repository = null;
        this.clearResolutionStatus();
        return this;
    }

    public RepositoryTargetLocation setRepository(RepositoryPlugin repository) {
        this.repositoryName = repository.getName();
        this.repository = repository;
        this.clearResolutionStatus();
        return this;
    }

    public RepositoryPlugin getRepository() {
        return this.repository;
    }

    public String getText(Object element) {
        return this.repositoryName;
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        RepositoryTargetLocationWizard wizard = new RepositoryTargetLocationWizard();
        wizard.setTarget(target);
        wizard.setTargetLocation(this);
        return wizard;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.resolveRepository();
        try {
            ArrayList<TargetBundle> bundles = new ArrayList<TargetBundle>();
            List bsns = this.repository.list("*");
            monitor.beginTask("Resolving Bundles", bsns.size());
            int i = 0;
            Iterator iterator = bsns.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    monitor.done();
                    return bundles.toArray(new TargetBundle[0]);
                }
                String bsn = (String)iterator.next();
                if (bsn.contains(":")) continue;
                Version version = (Version)this.repository.versions(bsn).last();
                File download = this.repository.get(bsn, version, new HashMap(), new RepositoryPlugin.DownloadListener[0]);
                try {
                    bundles.add(new TargetBundle(download));
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "bndtools.pde", "Invalid plugin in repository: " + bsn + " @ " + this.getLocation(false), (Throwable)e));
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                monitor.worked(++i);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "Unable to resolve bundles", (Throwable)e));
        }
    }

    private void resolveRepository() throws CoreException {
        Workspace workspace;
        try {
            workspace = BndTargetLocation.getWorkspace();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "Unable to locate the Bnd workspace", (Throwable)e));
        }
        try {
            if (this.repositoryName.equals(workspace.getWorkspaceRepository().getName())) {
                this.repository = workspace.getWorkspaceRepository();
            } else {
                for (RepositoryPlugin repository : workspace.getPlugins(RepositoryPlugin.class)) {
                    if (!this.repositoryName.equalsIgnoreCase(repository.getName())) continue;
                    this.repository = repository;
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", MESSAGE_UNABLE_TO_RESOLVE_REPOSITORIES, (Throwable)e));
        }
        if (this.repository == null) {
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "Unable to locate the named repository: " + this.repositoryName));
        }
    }

    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            this.resolveRepository();
        }
        return this.repository != null ? this.repository.getLocation() : "";
    }

    @Override
    protected void serialize(Document document, Element locationElement) {
        Element repositoryElement = document.createElement(ELEMENT_REPOSITORY);
        repositoryElement.setAttribute(ATTRIBUTE_REPOSITORY_NAME, this.repositoryName);
        locationElement.appendChild(repositoryElement);
    }

    public void dispose() {
    }

    public static class Factory
    extends BndTargetLocationFactory {
        public Factory() {
            super(RepositoryTargetLocation.TYPE);
        }

        @Override
        public ITargetLocation getTargetLocation(Element locationElement) throws CoreException {
            NodeList children = locationElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (this.isElement(node, RepositoryTargetLocation.ELEMENT_REPOSITORY)) {
                    String name = ((Element)node).getAttribute(RepositoryTargetLocation.ATTRIBUTE_REPOSITORY_NAME);
                    return new RepositoryTargetLocation().setRepository(name);
                }
                ++i;
            }
            throw new CoreException((IStatus)new Status(4, "bndtools.pde", "No repository name specified"));
        }
    }
}

