/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class AddRemoveButtonBarPart {
    private final List<AddRemoveListener> listeners = new ArrayList<AddRemoveListener>();
    private ToolBar toolbar;
    private ToolItem btnAdd;
    private ToolItem btnRemove;

    public ToolBar createControl(Composite parent, int style) {
        this.toolbar = new ToolBar(parent, style);
        this.btnAdd = new ToolItem(this.toolbar, 8);
        this.btnAdd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (AddRemoveListener l : AddRemoveButtonBarPart.this.listeners) {
                    l.addSelected();
                }
            }
        });
        this.btnRemove = new ToolItem(this.toolbar, 8);
        this.btnRemove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.btnRemove.setDisabledImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
        this.btnRemove.setToolTipText("Remove");
        this.btnRemove.setEnabled(false);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (AddRemoveListener l : AddRemoveButtonBarPart.this.listeners) {
                    l.removeSelected();
                }
            }
        });
        return this.toolbar;
    }

    public void setAddEnabled(boolean enable) {
        this.btnAdd.setEnabled(enable);
    }

    public void setRemoveEnabled(boolean enable) {
        this.btnRemove.setEnabled(enable);
    }

    public void addListener(AddRemoveListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AddRemoveListener l) {
        this.listeners.remove(l);
    }

    public static interface AddRemoveListener {
        public void addSelected();

        public void removeSelected();
    }
}

