/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class PrimitiveRatherThanWrapperOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final VariableDeclarationStatement visited;
    private final String primitiveTypeName;
    private final String wrapperFullyQualifiedName;
    private final Expression initializer;
    private final List<MethodInvocation> toStringMethods;
    private final List<MethodInvocation> compareToMethods;
    private final List<MethodInvocation> primitiveValueMethods;
    private final String parsingMethodName;

    public PrimitiveRatherThanWrapperOperation(VariableDeclarationStatement visited, String primitiveTypeName, String wrapperFullyQualifiedName, Expression initializer, List<MethodInvocation> toStringMethods, List<MethodInvocation> compareToMethods, List<MethodInvocation> primitiveValueMethods, String parsingMethodName) {
        this.visited = visited;
        this.primitiveTypeName = primitiveTypeName;
        this.wrapperFullyQualifiedName = wrapperFullyQualifiedName;
        this.initializer = initializer;
        this.toStringMethods = toStringMethods;
        this.compareToMethods = compareToMethods;
        this.primitiveValueMethods = primitiveValueMethods;
        this.parsingMethodName = parsingMethodName;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ListRewrite targetListRewrite;
        Type wrapperType;
        List classInstanceCreationArguments;
        ClassInstanceCreation classInstanceCreation;
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = cuRewrite.getRoot().getAST();
        TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PrimitiveRatherThanWrapperCleanUp_description, cuRewrite);
        rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

            public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                    return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                }
                return super.computeSourceRange(nodeWithComment);
            }
        });
        MethodInvocation methodInvocation = ASTNodes.as(this.initializer, MethodInvocation.class);
        if (methodInvocation != null) {
            if (ASTNodes.usesGivenSignature(methodInvocation, this.wrapperFullyQualifiedName, "valueOf", this.primitiveTypeName)) {
                rewrite.replace((ASTNode)methodInvocation, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)methodInvocation.arguments().get(0)), group);
            }
            if (ASTNodes.usesGivenSignature(methodInvocation, this.wrapperFullyQualifiedName, "valueOf", String.class.getCanonicalName()) || ASTNodes.usesGivenSignature(methodInvocation, this.wrapperFullyQualifiedName, "valueOf", String.class.getCanonicalName(), Integer.TYPE.getSimpleName())) {
                rewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY, (Object)ast.newSimpleName(this.parsingMethodName), group);
            }
        }
        if ((classInstanceCreation = ASTNodes.as(this.initializer, ClassInstanceCreation.class)) != null && (classInstanceCreationArguments = classInstanceCreation.arguments()).size() == 1 && ASTNodes.hasType((Expression)classInstanceCreation, this.wrapperFullyQualifiedName)) {
            Expression arg0 = (Expression)classInstanceCreationArguments.get(0);
            if (ASTNodes.hasType(arg0, String.class.getCanonicalName()) && this.parsingMethodName != null) {
                MethodInvocation newMethodInvocation = ast.newMethodInvocation();
                newMethodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)((SimpleType)this.visited.getType()).getName()));
                newMethodInvocation.setName(ast.newSimpleName(this.parsingMethodName));
                newMethodInvocation.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(arg0)));
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.initializer, (ASTNode)newMethodInvocation, group);
            } else if (ASTNodes.hasType(arg0, this.primitiveTypeName)) {
                Expression newExpression = (Expression)rewrite.createCopyTarget((ASTNode)arg0);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)classInstanceCreation, (ASTNode)newExpression, group);
            }
        }
        for (MethodInvocation primitiveValueMethod : this.primitiveValueMethods) {
            rewrite.replace((ASTNode)primitiveValueMethod, (ASTNode)ASTNodes.createMoveTarget(rewrite, primitiveValueMethod.getExpression()), group);
        }
        for (MethodInvocation toStringMethod : this.toStringMethods) {
            wrapperType = (Type)rewrite.createCopyTarget((ASTNode)this.visited.getType());
            targetListRewrite = rewrite.getListRewrite((ASTNode)toStringMethod, MethodInvocation.ARGUMENTS_PROPERTY);
            targetListRewrite.insertFirst((ASTNode)ASTNodes.createMoveTarget(rewrite, toStringMethod.getExpression()), group);
            rewrite.set((ASTNode)toStringMethod, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)wrapperType, group);
        }
        for (MethodInvocation compareToMethod : this.compareToMethods) {
            wrapperType = (Type)rewrite.createCopyTarget((ASTNode)this.visited.getType());
            targetListRewrite = rewrite.getListRewrite((ASTNode)compareToMethod, MethodInvocation.ARGUMENTS_PROPERTY);
            targetListRewrite.insertFirst((ASTNode)ASTNodes.createMoveTarget(rewrite, compareToMethod.getExpression()), group);
            rewrite.set((ASTNode)compareToMethod, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)wrapperType, group);
            rewrite.replace((ASTNode)compareToMethod.getName(), (ASTNode)ast.newSimpleName("compare"), group);
        }
        PrimitiveType newPrimitiveType = ast.newPrimitiveType(PrimitiveType.toCode((String)this.primitiveTypeName));
        ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited.getType(), (ASTNode)newPrimitiveType, group);
    }
}

