/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.PatternMatchingForInstanceofFixCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class PatternMatchingForInstanceofCleanUpCore
extends AbstractCleanUp {
    public PatternMatchingForInstanceofCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PatternMatchingForInstanceofCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.instanceof");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.instanceof") || !JavaModelUtil.is16OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        return PatternMatchingForInstanceofFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.instanceof")) {
            result.add(MultiFixMessages.PatternMatchingForInstanceofCleanup_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.instanceof")) {
            return "if (object instanceof Integer i) {\n    return i.intValue();\n}\n\n";
        }
        return "if (object instanceof Integer) {\n    Integer i = (Integer) object;\n    return i.intValue();\n}\n";
    }
}

