/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.util.Dictionary;
import org.osgi.framework.BundleContext;

public class Details {
    public static boolean getBoolean(BundleContext dictionary, String key, boolean dflt) {
        String value = dictionary.getProperty(key);
        if (value == null) {
            return dflt;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(Dictionary dictionary, String key, boolean dflt) {
        Object value = dictionary.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return dflt;
    }

    public static boolean getBooleanProp(BundleContext dictionary, String key, boolean dflt) {
        return Details.getBoolean(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static boolean getBooleanProp(Dictionary dictionary, String key, boolean dflt) {
        return Details.getBoolean(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static int getInt(BundleContext dictionary, String key, int dflt) {
        String value = dictionary.getProperty(key);
        if (value == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static int getInt(Dictionary dictionary, String key, int dflt) {
        Object value = dictionary.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }
        return dflt;
    }

    public static int getIntProp(BundleContext dictionary, String key, int dflt) {
        return Details.getInt(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static int getIntProp(Dictionary dictionary, String key, int dflt) {
        return Details.getInt(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static long getLong(BundleContext dictionary, String key, long dflt) {
        String value = dictionary.getProperty(key);
        if (value == null) {
            return dflt;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static long getLong(Dictionary dictionary, String key, long dflt) {
        Object value = dictionary.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return dflt;
            }
        }
        return dflt;
    }

    public static long getLongProp(BundleContext dictionary, String key, long dflt) {
        return Details.getLong(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static long getLongProp(Dictionary dictionary, String key, long dflt) {
        return Details.getLong(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static String getString(BundleContext dictionary, String key, String dflt) {
        String value = dictionary.getProperty(key);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public static String getString(Dictionary dictionary, String key, String dflt) {
        Object value = dictionary.get(key);
        if (value == null) {
            return dflt;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static String getStringProp(BundleContext dictionary, String key, String dflt) {
        return Details.getString(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }

    public static String getStringProp(Dictionary dictionary, String key, String dflt) {
        return Details.getString(dictionary, "org.eclipse.equinox.http.jetty." + key, dflt);
    }
}

