/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TemplateInvocationValidationException;
import org.junit.jupiter.params.ParameterizedDeclarationContext;
import org.junit.jupiter.params.ParameterizedInvocationNameFormatter;
import org.junit.jupiter.params.ParameterizedTestSpiInstantiator;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;

class ParameterizedInvocationContextProvider<T> {
    ParameterizedInvocationContextProvider() {
    }

    protected Stream<T> provideInvocationContexts(ExtensionContext extensionContext, ParameterizedDeclarationContext<T> declarationContext) {
        List<ArgumentsSource> argumentsSources = ParameterizedInvocationContextProvider.collectArgumentSources(declarationContext);
        ParameterDeclarations parameters = declarationContext.getResolverFacade().getIndexedParameterDeclarations();
        ParameterizedInvocationNameFormatter formatter = ParameterizedInvocationNameFormatter.create(extensionContext, declarationContext);
        AtomicLong invocationCount = new AtomicLong(0L);
        return (Stream)argumentsSources.stream().map(ArgumentsSource::value).map(clazz -> ParameterizedTestSpiInstantiator.instantiate(ArgumentsProvider.class, clazz, extensionContext)).map(provider -> AnnotationConsumerInitializer.initialize(declarationContext.getAnnotatedElement(), provider)).flatMap(provider -> ParameterizedInvocationContextProvider.arguments(provider, parameters, extensionContext)).map(arguments -> {
            invocationCount.incrementAndGet();
            return declarationContext.createInvocationContext(formatter, (Arguments)arguments, invocationCount.intValue());
        }).onClose(() -> ParameterizedInvocationContextProvider.validateInvokedAtLeastOnce(invocationCount.get(), declarationContext));
    }

    private static <T> void validateInvokedAtLeastOnce(long invocationCount, ParameterizedDeclarationContext<T> declarationContext) {
        if (invocationCount == 0L && !declarationContext.isAllowingZeroInvocations()) {
            String message = String.format("Configuration error: You must configure at least one set of arguments for this @%s", declarationContext.getAnnotationName());
            throw new TemplateInvocationValidationException(message);
        }
    }

    private static List<ArgumentsSource> collectArgumentSources(ParameterizedDeclarationContext<?> declarationContext) {
        List argumentsSources = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)declarationContext.getAnnotatedElement(), ArgumentsSource.class);
        Preconditions.notEmpty((Collection)argumentsSources, () -> String.format("Configuration error: You must configure at least one arguments source for this @%s", declarationContext.getAnnotationName()));
        return argumentsSources;
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ParameterDeclarations parameters, ExtensionContext context) {
        try {
            return provider.provideArguments(parameters, context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
        }
    }
}

