/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.text.plugin.PluginElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.nls.ModelChange;

public class ModelChangeElement {
    private static final String DELIM = ".";
    private static final String KEY_PREFIX = "%";
    private static final String FRAGMENT_PREFIX = "f";
    private String fValue = "";
    private String fKey = "";
    private int fOffset = 0;
    private int fLength = 0;
    private boolean fExternalized = true;
    private final ModelChange fParent;
    private final Object fUnderlying;

    public ModelChangeElement(ModelChange parent, Object incoming) {
        this.fParent = parent;
        this.fUnderlying = incoming;
        if (incoming instanceof PluginElementNode) {
            PluginElementNode elem = (PluginElementNode)incoming;
            IDocumentTextNode text = elem.getTextNode();
            this.fValue = elem.getText();
            this.generateValidKey(elem.getParent().getName(), elem.getName());
            this.fOffset = text.getOffset();
            this.fLength = text.getLength();
        } else if (incoming instanceof PluginAttribute) {
            PluginAttribute attr = (PluginAttribute)incoming;
            this.fValue = attr.getValue();
            this.generateValidKey(attr.getEnclosingElement().getXMLTagName(), attr.getName());
            this.fOffset = attr.getValueOffset();
            this.fLength = attr.getValueLength();
        } else if (incoming instanceof PluginExtensionPointNode) {
            PluginExtensionPointNode extP = (PluginExtensionPointNode)incoming;
            this.fValue = extP.getName();
            this.generateValidKey("extension-point", "name");
            IDocumentAttributeNode attr = extP.getDocumentAttribute("name");
            this.fOffset = attr.getValueOffset();
            this.fLength = attr.getValueLength();
        } else if (incoming instanceof ManifestHeader) {
            ManifestHeader header = (ManifestHeader)incoming;
            this.fValue = header.getValue();
            this.generateValidKey(header.getName());
            this.fLength = this.fValue.length();
            this.fOffset = header.getOffset() + header.getLength() - header.getLineLimiter().length() - this.fLength;
        }
    }

    public String getKey() {
        return this.fKey;
    }

    public void setKey(String key) {
        this.fKey = key;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public boolean isExternalized() {
        return this.fExternalized;
    }

    public void setExternalized(boolean externalzied) {
        this.fExternalized = externalzied;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    private void generateValidKey(String pre, String mid) {
        this.generateValidKey(pre + DELIM + mid);
    }

    private void generateValidKey(String key) {
        Properties properties = this.fParent.getProperties();
        this.fKey = key;
        if (properties.containsKey(this.fKey)) {
            String delimiter = this.fParent.getParentModel() instanceof IFragmentModel ? ".f" : DELIM;
            int suffix = 0;
            while (properties.containsKey(this.fKey + delimiter + suffix)) {
                ++suffix;
            }
            this.fKey = String.valueOf(this.fKey) + delimiter + suffix;
        }
        properties.setProperty(this.fKey, this.fValue);
    }

    public String getExternKey() {
        return KEY_PREFIX + this.fKey;
    }

    public boolean updateValue() {
        block6: {
            try {
                String key = this.getExternKey();
                Object object = this.fUnderlying;
                if (object instanceof PluginElementNode) {
                    PluginElementNode elem = (PluginElementNode)object;
                    elem.setText(key);
                    break block6;
                }
                Object object2 = this.fUnderlying;
                if (object2 instanceof PluginAttribute) {
                    PluginAttribute attr = (PluginAttribute)object2;
                    String attrName = attr.getName();
                    attr.getEnclosingElement().setXMLAttribute(attrName, key);
                    break block6;
                }
                Object object3 = this.fUnderlying;
                if (object3 instanceof PluginExtensionPointNode) {
                    PluginExtensionPointNode extP = (PluginExtensionPointNode)object3;
                    extP.setName(key);
                    break block6;
                }
                Object object4 = this.fUnderlying;
                if (object4 instanceof ManifestHeader) {
                    ManifestHeader header = (ManifestHeader)object4;
                    header.setValue(key);
                    break block6;
                }
                return false;
            }
            catch (CoreException e) {
                return false;
            }
        }
        return true;
    }
}

