/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public final class BuildJob
extends Job {
    private final IProject[] fProjects;
    private final int fBuildType;
    private static final String API_TOOL_PLUGIN_ID = "org.eclipse.pde.api.tools";
    private static final String API_TOOL_NATURE = "org.eclipse.pde.api.tools.apiAnalysisNature";

    BuildJob(String name, IProject[] projects) {
        this(name, projects, 6);
    }

    BuildJob(String name, IProject[] projects, int buildType) {
        super(name);
        this.fProjects = projects;
        this.fBuildType = buildType;
    }

    public boolean belongsTo(Object family) {
        return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
    }

    public boolean isCoveredBy(BuildJob other) {
        if (other.fProjects == null) {
            return true;
        }
        if (this.fProjects != null) {
            int i = 0;
            int max = this.fProjects.length;
            while (i < max) {
                if (!other.contains(this.fProjects[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean contains(IProject project) {
        if (project == null) {
            return false;
        }
        IProject[] iProjectArray = this.fProjects;
        int n = this.fProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject fProject = iProjectArray[n2];
            if (project.equals((Object)fProject)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        block19: {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.cancelBuild(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            }
            try {
                try {
                    if (this.fProjects == null) break block19;
                    SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.BuildJob_buildingProjects, (int)this.fProjects.length);
                    IProject[] iProjectArray = this.fProjects;
                    int n = this.fProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject currentProject = iProjectArray[n2];
                        if (this.fBuildType == 6) {
                            BuildJob.setNullLastBuiltState(currentProject);
                        }
                        localmonitor.subTask(NLS.bind((String)PDEUIMessages.BuildJob_buildingProject, (Object)currentProject.getName()));
                        try {
                            HashSet<String> typesToDelete = new HashSet<String>();
                            IMarker[] findMarkers = currentProject.findMarkers(null, true, 2);
                            if (findMarkers != null) {
                                IMarker[] iMarkerArray = findMarkers;
                                int n3 = findMarkers.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IMarker iMarker = iMarkerArray[n4];
                                    if (iMarker.getType().startsWith(API_TOOL_PLUGIN_ID)) {
                                        typesToDelete.add(iMarker.getType());
                                    }
                                    ++n4;
                                }
                            }
                            for (String typeMarker : typesToDelete) {
                                currentProject.deleteMarkers(typeMarker, false, 2);
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        currentProject.build(6, (IProgressMonitor)localmonitor.split(1));
                        ++n2;
                    }
                }
                catch (CoreException localmonitor) {
                    monitor.done();
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    private void cancelBuild(Object jobfamily) {
        Job[] buildJobs;
        Job[] jobArray = buildJobs = Job.getJobManager().find(jobfamily);
        int n = buildJobs.length;
        int n2 = 0;
        while (n2 < n) {
            BuildJob job;
            Job curr = jobArray[n2];
            if (curr != this && curr instanceof BuildJob && (job = (BuildJob)curr).isCoveredBy(this)) {
                curr.cancel();
            }
            ++n2;
        }
    }

    public static void setNullLastBuiltState(IProject project) {
        try {
            File file = BuildJob.getSerializationFile(project);
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation(API_TOOL_PLUGIN_ID);
        return workingLocation.append("state.dat").toFile();
    }

    public static IProject[] getApiProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> temp = new ArrayList<IProject>();
        IProject project = null;
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            project = allProject;
            if (project.isAccessible()) {
                try {
                    if (project.hasNature(API_TOOL_NATURE)) {
                        temp.add(project);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        IProject[] projects = null;
        if (!temp.isEmpty()) {
            projects = new IProject[temp.size()];
            temp.toArray(projects);
        }
        return projects;
    }

    public static Job getBuildJob(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(PDEUIMessages.BuildJob_building, projects);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }
}

