/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

class DecoratableResourceAdapter
extends DecoratableResource {
    public DecoratableResourceAdapter(@NonNull IndexDiffData indexDiffData, @NonNull IResource resourceToWrap) {
        super(resourceToWrap);
        boolean trace = GitTraceLocation.DECORATION.isActive();
        long start = 0L;
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decorate " + String.valueOf(resourceToWrap.getFullPath()));
            start = System.nanoTime();
        }
        try {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resourceToWrap);
            if (mapping == null) {
                return;
            }
            Repository repository = mapping.getRepository();
            if (repository == null) {
                return;
            }
            this.setIsRepositoryContainer(resourceToWrap.equals((Object)mapping.getContainer()));
            GitItemState baseState = GitItemStateFactory.getInstance().get(indexDiffData, resourceToWrap);
            this.setTracked(baseState.isTracked());
            this.setIgnored(baseState.isIgnored());
            this.setDirty(baseState.isDirty());
            this.setConflicts(baseState.hasConflicts());
            this.setAssumeUnchanged(baseState.isAssumeUnchanged());
            this.setStagingState(baseState.getStagingState());
            this.setConflictType(baseState.getConflictType());
            if (this.isRepositoryContainer() && !this.isIgnored()) {
                this.repositoryName = DecoratorRepositoryStateCache.INSTANCE.getRepositoryNameAndState(repository);
                this.branch = DecoratorRepositoryStateCache.INSTANCE.getCurrentBranchLabel(repository);
                this.branchStatus = DecoratorRepositoryStateCache.INSTANCE.getBranchStatus(repository);
                RevCommit headCommit = DecoratorRepositoryStateCache.INSTANCE.getHeadCommit(repository);
                if (headCommit != null) {
                    this.commitMessage = headCommit.getShortMessage();
                }
            }
        }
        finally {
            if (trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decoration took " + (System.nanoTime() - start) + " ns");
            }
        }
    }

    @Override
    public String toString() {
        return "DecoratableResourceAdapter[" + this.getName() + (this.isTracked() ? ", tracked" : "") + (this.isIgnored() ? ", ignored" : "") + (this.isDirty() ? ", dirty" : "") + (this.hasConflicts() ? ",conflicts" : "") + ", staged=" + String.valueOf(this.getStagingState()) + "]";
    }
}

