/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.DeleteTagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class DeleteTagCommand
extends RepositoriesViewCommandHandler<TagNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List tags = this.getSelectedNodes(event);
        if (tags.isEmpty()) {
            return null;
        }
        final AtomicBoolean confirmed = new AtomicBoolean();
        final Shell shell = this.getActiveShell(event);
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String message = tags.size() > 1 ? MessageFormat.format(UIText.DeleteTagCommand_messageConfirmMultipleTag, tags.size()) : MessageFormat.format(UIText.DeleteTagCommand_messageConfirmSingleTag, Repository.shortenRefName((String)((Ref)((TagNode)tags.get(0)).getObject()).getName()));
                confirmed.set(MessageDialog.openConfirm((Shell)shell, (String)UIText.DeleteTagCommand_titleConfirm, (String)message));
            }
        });
        if (!confirmed.get()) {
            return null;
        }
        Job job = new Job(UIText.DeleteTagCommand_taskName){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)UIText.DeleteTagCommand_taskName, (int)tags.size());
                for (TagNode tag : tags) {
                    if (progress.isCanceled()) break;
                    Repository repo = tag.getRepository();
                    String tagName = ((Ref)tag.getObject()).getName();
                    DeleteTagOperation op = new DeleteTagOperation(repo, tagName);
                    monitor.subTask(tagName);
                    try {
                        op.execute((IProgressMonitor)progress.newChild(1));
                    }
                    catch (CoreException e) {
                        Activator.logError(e.getLocalizedMessage(), e);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.TAG.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

