/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;

public class EchoHandler
extends Handler.Abstract {
    @Override
    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.BLOCKING;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) {
        response.setStatus(200);
        long contentLength = -1L;
        for (HttpField field : request.getHeaders()) {
            if (field.getHeader() == null) continue;
            switch (field.getHeader()) {
                case CONTENT_LENGTH: {
                    response.getHeaders().add(field);
                    contentLength = field.getLongValue();
                    break;
                }
                case CONTENT_TYPE: {
                    response.getHeaders().add(field);
                    break;
                }
                case TRAILER: {
                    response.setTrailersSupplier((Supplier<HttpFields>)HttpFields.build());
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentLength = Long.MAX_VALUE;
                }
            }
        }
        if (contentLength > 0L) {
            this.copy(request, response, callback);
        } else {
            callback.succeeded();
        }
        return true;
    }

    protected void copy(Request request, Response response, Callback callback) {
        Content.copy((Content.Source)request, (Content.Sink)response, (Content.Chunk.Processor)Response.newTrailersChunkProcessor(response), (Callback)callback);
    }

    public static class BufferedAsync
    extends EchoHandler {
        @Override
        protected void copy(Request request, final Response response, final Callback callback) {
            Content.Source.asByteBuffer((Content.Source)request, (Promise)new Promise<ByteBuffer>(this){
                final /* synthetic */ BufferedAsync this$0;
                {
                    this.this$0 = this$0;
                }

                public void succeeded(ByteBuffer result) {
                    response.write(true, result, callback);
                }

                public void failed(Throwable x) {
                    callback.failed(x);
                }
            });
        }
    }

    public static class Buffered
    extends EchoHandler {
        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        protected void copy(Request request, Response response, Callback callback) {
            try {
                response.write(true, Content.Source.asByteBuffer((Content.Source)request), callback);
            }
            catch (IOException e) {
                callback.failed((Throwable)e);
            }
        }
    }

    public static class Stream
    extends EchoHandler {
        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        protected void copy(Request request, Response response, Callback callback) {
            try {
                IO.copy((InputStream)Content.Source.asInputStream((Content.Source)request), (OutputStream)Content.Sink.asOutputStream((Content.Sink)response));
                callback.succeeded();
            }
            catch (IOException e) {
                callback.failed((Throwable)e);
            }
        }
    }

    public static class Reactive
    extends EchoHandler {
        @Override
        protected void copy(Request request, Response response, Callback callback) {
            Content.Source.asPublisher((Content.Source)request).subscribe(Content.Sink.asSubscriber((Content.Sink)response, (Callback)callback));
        }
    }
}

