/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;

public final class KeywordRegistry
implements IExtensionChangeHandler {
    private static final String ATT_ID = "id";
    private static final String ATT_LABEL = "label";
    private static KeywordRegistry instance;
    private static final String TAG_KEYWORD = "keyword";
    private Map internalKeywordMap = new HashMap();

    public static KeywordRegistry getInstance() {
        if (instance == null) {
            instance = new KeywordRegistry();
        }
        return instance;
    }

    private KeywordRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        IExtension[] iExtensionArray = this.getExtensionPointFilter().getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(PlatformUI.getWorkbench().getExtensionTracker(), extension);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_KEYWORD)) {
                String name = element.getAttribute(ATT_LABEL);
                String id = element.getAttribute(ATT_ID);
                this.internalKeywordMap.put(id, name);
                PlatformUI.getWorkbench().getExtensionTracker().registerObject(extension, (Object)id, 2);
            }
            ++n2;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "keywords");
    }

    public String getKeywordLabel(String id) {
        return (String)this.internalKeywordMap.get(id);
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                this.internalKeywordMap.remove(object);
            }
            ++n2;
        }
    }
}

