/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;

public class StandardSourcePathProvider
extends StandardClasspathProvider {
    @Override
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, true);
        IRuntimeClasspathEntry[] entries = null;
        entries = useDefault ? super.computeUnresolvedClasspath(configuration) : this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH);
        return entries;
    }

    @Override
    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        UniqueList all = new UniqueList(entries.length);
        int i = 0;
        while (i < entries.length) {
            switch (entries[i].getType()) {
                case 1: {
                    all.add(entries[i]);
                    break;
                }
                case 5: {
                    IRuntimeClasspathEntry2 entry = (IRuntimeClasspathEntry2)entries[i];
                    String typeId = entry.getTypeId();
                    IRuntimeClasspathEntry[] res = null;
                    switch (typeId) {
                        case "org.eclipse.jdt.launching.classpathentry.defaultClasspath": {
                            IRuntimeClasspathEntry[] children = entry.getRuntimeClasspathEntries(configuration);
                            res = JavaRuntime.resolveSourceLookupPath(children, configuration);
                            break;
                        }
                        case "org.eclipse.jdt.launching.classpathentry.variableClasspathEntry": {
                            res = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, configuration);
                            break;
                        }
                        default: {
                            res = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, configuration);
                        }
                    }
                    if (res == null) break;
                    int j = 0;
                    while (j < res.length) {
                        all.add(res[j]);
                        this.addManifestReferences(res[j], all);
                        ++j;
                    }
                    break;
                }
                default: {
                    IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry(entries[i], configuration);
                    int j = 0;
                    while (j < resolved.length) {
                        all.add(resolved[j]);
                        this.addManifestReferences(resolved[j], all);
                        ++j;
                    }
                    break block0;
                }
            }
            ++i;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    protected void addManifestReferences(IRuntimeClasspathEntry entry, List<IRuntimeClasspathEntry> all) {
        String location;
        if (entry.getType() == 2 && (location = entry.getLocation()) != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jar = new JarFile(location, false);){
                    String value;
                    Attributes mainAttributes;
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (mainAttributes = manifest.getMainAttributes()) != null && (value = mainAttributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                        String[] entries = value.split("\\s+");
                        Path base = new Path(location);
                        base = base.removeLastSegments(1);
                        int i = 0;
                        while (i < entries.length) {
                            IRuntimeClasspathEntry ref;
                            IPath path = base.append(entries[i]);
                            if (path.toFile().exists() && !all.contains(ref = JavaRuntime.newArchiveRuntimeClasspathEntry(path))) {
                                all.add(ref);
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class UniqueList
    extends ArrayList<IRuntimeClasspathEntry> {
        private static final long serialVersionUID = -7402160651027036270L;
        HashSet<IRuntimeClasspathEntry> set;

        public UniqueList(int length) {
            super(length);
            this.set = new HashSet(length);
        }

        @Override
        public void add(int index, IRuntimeClasspathEntry element) {
            if (this.set.add(element)) {
                super.add(index, element);
            }
        }

        @Override
        public boolean add(IRuntimeClasspathEntry o) {
            if (this.set.add(o)) {
                return super.add(o);
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends IRuntimeClasspathEntry> c) {
            if (this.set.addAll(c)) {
                return super.addAll(c);
            }
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<? extends IRuntimeClasspathEntry> c) {
            if (this.set.addAll(c)) {
                return super.addAll(index, c);
            }
            return false;
        }

        @Override
        public void clear() {
            this.set.clear();
            super.clear();
        }

        @Override
        public boolean contains(Object elem) {
            return this.set.contains(elem);
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            super.ensureCapacity(minCapacity);
        }

        @Override
        public IRuntimeClasspathEntry remove(int index) {
            IRuntimeClasspathEntry object = (IRuntimeClasspathEntry)super.remove(index);
            this.set.remove(object);
            return object;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            int index = fromIndex;
            while (index <= toIndex) {
                this.remove(index);
                ++index;
            }
        }

        @Override
        public IRuntimeClasspathEntry set(int index, IRuntimeClasspathEntry element) {
            this.set.remove(element);
            if (this.set.add(element)) {
                return super.set(index, element);
            }
            return null;
        }
    }
}

