/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.commands;

import org.apache.poi.ss.util.CellReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclMap;
import org.eclipse.rcptt.ecl.core.EclMapEntry;
import org.eclipse.rcptt.ecl.data.apache.poi.commands.SetTableCells;
import org.eclipse.rcptt.ecl.data.apache.poi.impl.internal.EclDataApachePOIImplPlugin;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class SetTableCellsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        SetTableCells setTableCells = (SetTableCells)command;
        Table table = setTableCells.getTable();
        EclMap cells = setTableCells.getCells();
        for (EclMapEntry entry : cells.getEntries()) {
            String key = this.getValue(entry.getKey());
            if (key == null || key.equals("")) {
                return EclDataApachePOIImplPlugin.createErr("Error getting 'cells' parameter. Map key must not be null or empty", new Object[0]);
            }
            String value = this.getValue(entry.getValue());
            this.addCellValue(table, key, value);
        }
        context.getOutput().write((Object)table);
        return Status.OK_STATUS;
    }

    private void addCellValue(Table table, String cellName, String cellValue) throws CoreException {
        Row row;
        CellReference cellRef = new CellReference(cellName);
        int rowIndex = cellRef.getRow();
        short colIndex = cellRef.getCol();
        if (rowIndex < 0 || colIndex < 0) {
            throw new CoreException(EclDataApachePOIImplPlugin.createErr("Invalid value of 'cells' parameter: %s is an invalid cell name", cellName));
        }
        if (rowIndex >= table.getRows().size()) {
            int i = table.getRows().size();
            while (i <= rowIndex) {
                Row row2 = ObjectsFactory.eINSTANCE.createRow();
                table.getRows().add(i, (Object)row2);
                ++i;
            }
        }
        if (colIndex >= (row = (Row)table.getRows().get(rowIndex)).getValues().size()) {
            int i = row.getValues().size();
            while (i <= colIndex) {
                row.getValues().add(i, (Object)"");
                ++i;
            }
        }
        row.getValues().set((int)colIndex, (Object)cellValue);
    }

    private String getValue(EObject obj) {
        Object object = BoxedValues.unbox((Object)obj);
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }
}

