/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalMethodReference;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class IllegalMethodReferenceDetector
extends AbstractIllegalMethodReference {
    private final Map<String, String> fIllegalTypes = new HashMap<String, String>();

    void addIllegalType(IReferenceTypeDescriptor type, String componentid) {
        this.fIllegalTypes.put(type.getQualifiedName(), componentid);
    }

    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        if (super.considerReference(reference, monitor)) {
            return true;
        }
        if (this.isEnclosedBy(reference.getReferencedTypeName(), this.fIllegalTypes.keySet())) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        if (super.isProblem(reference, monitor)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(reference.getReferencedTypeName(), "$");
        String compid = null;
        while (tokenizer.hasMoreTokens()) {
            compid = this.fIllegalTypes.get(tokenizer.nextToken());
            if (compid != null) break;
        }
        return this.isReferenceFromComponent(reference, compid);
    }

    @Override
    public int getReferenceKinds() {
        return 1049536;
    }

    @Override
    protected int getProblemKind() {
        return 3;
    }

    @Override
    protected String getSeverityKey() {
        return "ILLEGAL_REFERENCE";
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        if (method.isConstructor()) {
            return new String[]{Signatures.getMethodSignature(method), this.getSimpleTypeName(reference.getMember())};
        }
        return new String[]{this.getSimpleTypeName(method), this.getSimpleTypeName(reference.getMember()), Signatures.getMethodSignature(method)};
    }

    @Override
    protected Position getSourceRange(IType type, IDocument document, IReference reference) throws CoreException, BadLocationException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        Position pos = this.getMethodNameRange(method.isConstructor(), Signatures.getMethodName(method), document, reference);
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        return new String[]{this.getQualifiedTypeName(method), this.getQualifiedTypeName(reference.getMember()), Signatures.getMethodSignature(method)};
    }
}

