/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.UseScanReferences;

public abstract class Component
extends AbstractApiTypeContainer
implements IApiComponent {
    private volatile IApiDescription fApiDescription;
    private volatile IApiFilterStore fFilterStore;
    private volatile IReferenceCollection fReferences;
    private volatile boolean disposed;

    public Component(IApiBaseline baseline) {
        super(baseline, 1, null);
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            super.accept(visitor);
        }
        visitor.end(this);
    }

    @Override
    public IApiComponent getHost() throws CoreException {
        return null;
    }

    @Override
    public IApiBaseline getBaseline() {
        return (IApiBaseline)this.getAncestor(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        block14: {
            try {
                try {
                    this.close();
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                    Component component = this;
                    synchronized (component) {
                        this.fApiDescription = null;
                        this.disposed = true;
                        break block14;
                    }
                }
            }
            catch (Throwable throwable) {
                Component component = this;
                synchronized (component) {
                    this.fApiDescription = null;
                    this.disposed = true;
                }
                throw throwable;
            }
            Component component = this;
            synchronized (component) {
                this.fApiDescription = null;
                this.disposed = true;
            }
        }
    }

    @Override
    public IApiComponent getApiComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IApiDescription getApiDescription() throws CoreException {
        if (this.fApiDescription != null) {
            return this.fApiDescription;
        }
        Component component = this;
        synchronized (component) {
            this.fApiDescription = this.createApiDescription();
        }
        return this.fApiDescription;
    }

    protected boolean isApiDescriptionInitialized() {
        return this.fApiDescription != null;
    }

    protected boolean hasApiFilterStore() {
        return this.fFilterStore != null;
    }

    @Override
    public IApiTypeContainer[] getApiTypeContainers() throws CoreException {
        return super.getApiTypeContainers();
    }

    @Override
    public IApiTypeContainer[] getApiTypeContainers(String id) throws CoreException {
        if (this.hasFragments()) {
            return super.getApiTypeContainers(id);
        }
        return super.getApiTypeContainers();
    }

    protected abstract IApiDescription createApiDescription() throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IApiFilterStore getFilterStore() throws CoreException {
        if (this.fFilterStore == null) {
            Component component = this;
            synchronized (component) {
                if (this.fFilterStore == null) {
                    this.fFilterStore = this.createApiFilterStore();
                }
            }
        }
        return this.fFilterStore;
    }

    @Override
    public IElementDescriptor getHandle() {
        return Factory.componentDescriptor(this.getSymbolicName(), this.getVersion());
    }

    @Override
    public int getContainerType() {
        return 4;
    }

    protected abstract IApiFilterStore createApiFilterStore() throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IReferenceCollection getExternalDependencies() {
        if (this.fReferences == null) {
            Component component = this;
            synchronized (component) {
                if (this.fReferences == null) {
                    this.fReferences = new UseScanReferences();
                }
            }
        }
        return this.fReferences;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

