/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.rcptt.core.model.IOpenable;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Model;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7ElementInfo;
import org.eclipse.rcptt.internal.core.model.Util;

public abstract class Q7Element
extends PlatformObject
implements IQ7Element {
    public static final IQ7Element[] NO_ELEMENTS = new IQ7Element[0];
    protected static final Object NO_INFO = new Object();
    protected Q7Element parent;

    protected Q7Element(Q7Element parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    protected abstract Q7ElementInfo createElementInfo();

    protected boolean isInWorkingCopyMode() {
        return false;
    }

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public void close() throws ModelException, InterruptedException {
        ModelManager.getModelManager().removeInfoAndChildren(this);
    }

    @Override
    public IQ7Element getAncestor(IQ7Element.HandleType type) {
        IQ7Element element = this;
        while (element != null) {
            if (element.getElementType().equals((Object)type)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public ModelException newNotPresentException() {
        Q7Status status = new Q7Status(4, "Element: " + String.valueOf(this.getPath()) + " doesn't exist");
        status.setStatusCode(Q7Status.Q7StatusCode.NotPressent);
        return new ModelException(status);
    }

    @Override
    public IQ7Element getParent() {
        return this.parent;
    }

    @Override
    public IQ7Project getQ7Project() {
        IQ7Element current = this;
        do {
            if (!(current instanceof IQ7Project)) continue;
            return (IQ7Project)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public IQ7Model getModel() {
        IQ7Element current = this;
        do {
            if (!(current instanceof IQ7Model)) continue;
            return (IQ7Model)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public final <V> V accessInfo(Function<Q7ElementInfo, V> infoTovalue) throws InterruptedException {
        return ModelManager.getModelManager().accessInfo(this, infoTovalue);
    }

    public final <V> Optional<V> peekInfo(Function<Q7ElementInfo, V> infoTovalue) throws InterruptedException {
        return ModelManager.getModelManager().peekInfo(this, infoTovalue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        if (o == null) {
            return false;
        }
        Q7Element other = (Q7Element)o;
        return this.getName().equals(other.getName()) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getName().hashCode(), this.parent.hashCode());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        try {
            if (!this.peekInfo(info -> {
                this.toStringInfo(tab, buffer, info);
                return true;
            }).isPresent()) {
                this.toStringInfo(tab, buffer, null);
            }
        }
        catch (InterruptedException e) {
            OperationCanceledException result = new OperationCanceledException();
            result.initCause((Throwable)e);
            throw result;
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
        this.toStringChildren(tab, buffer, info);
    }

    protected void toStringAncestors(StringBuffer buffer) {
        Q7Element parentElement = (Q7Element)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof Q7ElementInfo)) {
            return;
        }
        IQ7Element[] children = ((Q7ElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((Q7Element)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }
}

