/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class AddMissingJavadocTagProposalCore
extends LinkedCorrectionProposalCore {
    private final ASTNode fDecl;
    private final ASTNode fMissingNode;

    public AddMissingJavadocTagProposalCore(String label, ICompilationUnit cu, ASTNode decl, ASTNode missingNode, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        this.fDecl = decl;
        this.fMissingNode = missingNode;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.insertMissingJavadocTag(rewrite, this.fMissingNode, (BodyDeclaration)this.fDecl);
        return rewrite;
    }

    private void insertMissingJavadocTag(ASTRewrite rewrite, ASTNode missingNode, BodyDeclaration bodyDecl) {
        TagElement newTag;
        AST ast = bodyDecl.getAST();
        Javadoc javadoc = bodyDecl.getJavadoc();
        if (javadoc == null) {
            javadoc = ast.newJavadoc();
            rewrite.set((ASTNode)bodyDecl, (StructuralPropertyDescriptor)bodyDecl.getJavadocProperty(), (Object)javadoc, null);
        }
        ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        StructuralPropertyDescriptor location = missingNode.getLocationInParent();
        if (location == SingleVariableDeclaration.NAME_PROPERTY) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)missingNode.getParent();
            String name = ((SimpleName)missingNode).getIdentifier();
            newTag = ast.newTagElement();
            newTag.setTagName("@param");
            newTag.fragments().add(ast.newSimpleName(name));
            if (bodyDecl instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDecl;
                List params = methodDeclaration.parameters();
                Set<String> sameKindLeadingNames = JavadocTagsSubProcessorCore.getPreviousParamNames(params, (ASTNode)decl);
                List typeParams = methodDeclaration.typeParameters();
                for (TypeParameter typeParam : typeParams) {
                    String curr = "<" + typeParam.getName().getIdentifier() + ">";
                    sameKindLeadingNames.add(curr);
                }
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
            } else if (bodyDecl instanceof RecordDeclaration) {
                RecordDeclaration recordDeclaration = (RecordDeclaration)bodyDecl;
                List params = recordDeclaration.recordComponents();
                Set<String> sameKindLeadingNames = JavadocTagsSubProcessorCore.getPreviousParamNames(params, (ASTNode)decl);
                List typeParams = recordDeclaration.typeParameters();
                for (TypeParameter typeParam : typeParams) {
                    String curr = "<" + typeParam.getName().getIdentifier() + ">";
                    sameKindLeadingNames.add(curr);
                }
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
            }
        } else if (location == TypeParameter.NAME_PROPERTY) {
            TypeParameter typeParam = (TypeParameter)missingNode.getParent();
            String name = "<" + ((SimpleName)missingNode).getIdentifier() + ">";
            newTag = ast.newTagElement();
            newTag.setTagName("@param");
            TextElement text = ast.newTextElement();
            text.setText(name);
            newTag.fragments().add(text);
            List params = bodyDecl instanceof TypeDeclaration ? ((TypeDeclaration)bodyDecl).typeParameters() : (bodyDecl instanceof RecordDeclaration ? ((RecordDeclaration)bodyDecl).typeParameters() : ((MethodDeclaration)bodyDecl).typeParameters());
            JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousTypeParamNames(params, (ASTNode)typeParam));
        } else if (location == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
            newTag = ast.newTagElement();
            newTag.setTagName("@return");
            JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, null);
        } else if (location == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
            newTag = ast.newTagElement();
            newTag.setTagName("@throws");
            TextElement excNode = ast.newTextElement();
            excNode.setText(ASTNodes.getQualifiedTypeName((Type)missingNode));
            newTag.fragments().add(excNode);
            List exceptions = ((MethodDeclaration)bodyDecl).thrownExceptionTypes();
            JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousExceptionNames(exceptions, missingNode));
        } else {
            Assert.isTrue((boolean)false, (String)"AddMissingJavadocTagProposal: unexpected node location");
            return;
        }
        TextElement textElement = ast.newTextElement();
        textElement.setText("");
        newTag.fragments().add(textElement);
        this.addLinkedPosition(rewrite.track((ASTNode)textElement), false, "comment_start");
        if (bodyDecl.getJavadoc() == null) {
            newTag.fragments().add(ast.newTextElement());
        }
    }
}

