/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.streams;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.rcptt.sherlock.core.SherlockCore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportFormat;

public class SherlockReportOutputStream
implements Closeable {
    private ZipOutputStream stream;
    int index = 0;

    public SherlockReportOutputStream(OutputStream out) {
        this.stream = new ZipOutputStream(out);
    }

    public synchronized String write(Report report) {
        String postfix = "";
        if (report.getRoot().getName() != null) {
            postfix = SherlockCore.getID(report.getRoot().getName());
        }
        String id = this.index + "_" + postfix + ".report";
        ZipEntry entry = new ZipEntry(id);
        entry.setTime(1L);
        ++this.index;
        try {
            this.stream.putNextEntry(entry);
            SherlockReportFormat.storeReport(report, this.stream, false);
        }
        catch (IOException e) {
            SherlockCore.log(e);
            return null;
        }
        return id;
    }

    @Override
    public void close() {
        if (this.index > 0) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                SherlockCore.log(e);
            }
        }
    }
}

