/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.StatusInfo;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class HistoryListDialog
extends StatusDialog {
    private final List<String> fHistoryList = new ArrayList<String>();
    private IStatus fHistoryStatus;
    private TableViewer fHistoryViewer;
    private Button fRemoveButton;
    private String fResult;

    public HistoryListDialog(Shell shell, String[] elements) {
        super(shell);
        this.setTitle(PDEUIMessages.HistoryListDialog_title);
        this.fHistoryList.addAll(Arrays.asList(elements));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.history_list_dialog");
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(PDEUIMessages.HistoryListDialog_label);
        Composite container = this.createListArea(inner);
        container.setLayoutData((Object)new GridData(1808));
        HistoryListDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createListArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout();
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.numColumns = 2;
        container.setLayout((Layout)layout1);
        container.setLayoutData((Object)new GridData(1808));
        this.createTableArea(container);
        this.createListButtons(container);
        return container;
    }

    private void createListButtons(Composite parent) {
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(PDEUIMessages.HistoryListDialog_remove_button);
        this.fRemoveButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = this.fHistoryViewer.getStructuredSelection();
            if (!selection.isEmpty()) {
                Object removalCandidate = selection.getFirstElement();
                this.fHistoryList.remove(removalCandidate);
                this.fHistoryViewer.remove(removalCandidate);
            }
        }));
    }

    private Control createTableArea(Composite parent) {
        Table table = new Table(parent, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        table.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }));
        this.fHistoryViewer = new TableViewer(table);
        DependenciesLabelProvider labelProvider = new DependenciesLabelProvider(false);
        this.fHistoryViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fHistoryViewer.getControl().addDisposeListener(e -> labelProvider.dispose());
        this.fHistoryViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fHistoryViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fHistoryViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        StructuredSelection sel = !this.fHistoryList.isEmpty() ? new StructuredSelection((Object)this.fHistoryList.get(0)) : new StructuredSelection();
        this.fHistoryViewer.setSelection((ISelection)sel);
        this.fHistoryViewer.addSelectionChangedListener(event -> {
            StatusInfo status = new StatusInfo();
            IStructuredSelection selection = this.fHistoryViewer.getStructuredSelection();
            List selected = selection.toList();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (String)selected.get(0);
            }
            this.fRemoveButton.setEnabled(this.fHistoryList.size() > selected.size() && !selected.isEmpty());
            this.fHistoryStatus = status;
            this.updateStatus(status);
        });
        return this.fHistoryViewer.getControl();
    }

    public String[] getRemaining() {
        return this.fHistoryList.toArray(new String[this.fHistoryList.size()]);
    }

    public String getResult() {
        return this.fResult;
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return HistoryListDialog.this.fHistoryList.toArray();
        }
    }
}

