/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.rcptt.tesla.core.protocol.TeslaStream;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;

public class TeslaQStream
extends TeslaStream {
    private static final int TIMEOUT = 100;
    private BlockingQueue<Object> out = new LinkedBlockingQueue<Object>(10);
    private BlockingQueue<Object> in = new LinkedBlockingQueue<Object>(10);
    private boolean active = true;

    public TeslaQStream(TeslaQStream reverse) {
        if (reverse != null) {
            this.out = reverse.in;
            this.in = reverse.out;
        }
    }

    @Override
    public void terminate() {
        this.active = false;
    }

    public boolean hasCommand() {
        return !this.in.isEmpty();
    }

    @Override
    public Command readCommand() {
        try {
            Command value = null;
            while (value == null && this.active) {
                value = (Command)this.in.poll(100L, TimeUnit.MILLISECONDS);
            }
            return value;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response readResponse() {
        try {
            Response response = null;
            while (response == null && this.active) {
                response = (Response)this.in.poll(100L, TimeUnit.MILLISECONDS);
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeCommand(Command command) {
        try {
            this.out.put(command);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeResponse(Response command) {
        try {
            this.out.put(command);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

