/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import org.eclipse.core.runtime.Assert;
import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.CanvasUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.EditorUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.FormTextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.PartUIElement;
import org.eclipse.rcptt.tesla.core.protocol.TextUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.ViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;

public class CompositeUIElement
extends ControlUIElement {
    private final Selectors selector = new Selectors();

    @Override
    protected void updateAfter(Element e) {
        super.updateAfter(e);
        this.selector.button.after = e;
        this.selector.label.after = e;
        this.selector.text.after = e;
        this.selector.combo.after = e;
        this.selector.link.after = e;
        this.selector.diagramViewer.after = e;
        this.selector.paletteViewer.after = e;
        this.selector.formText.after = e;
        this.selector.view.after = e;
        this.selector.editor.after = e;
        this.selector.group.after = e;
        this.selector.expandable.after = e;
        this.selector.cbanner.after = e;
        this.selector.coolbar.after = e;
        this.selector.toolbar.after = e;
        this.selector.any.after = e;
        this.selector.canvas.after = e;
        this.selector.tree.after = e;
        this.selector.list.after = e;
        this.selector.table.after = e;
        this.selector.tabItem.after = e;
        this.selector.tabFolder.after = e;
    }

    public CompositeUIElement(Element e, UIPlayer player) {
        super(e, player);
        this.selector.button = new UISelector<ControlUIElement>(ElementKind.Button, (IUIPlayer)player, ControlUIElement.class).parent(this.element);
        this.selector.text = new UISelector<TextUIElement>(ElementKind.Text, (IUIPlayer)player, TextUIElement.class).parent(this.element);
        this.selector.combo = new UISelector<TextUIElement>(ElementKind.Combo, (IUIPlayer)player, TextUIElement.class).parent(this.element);
        this.selector.formText = new UISelector<FormTextUIElement>(ElementKind.FormText, (IUIPlayer)player, FormTextUIElement.class).parent(this.element);
        this.selector.label = new UISelector<ControlUIElement>(ElementKind.Label, (IUIPlayer)player, ControlUIElement.class).parent(this.element);
        this.selector.tree = new UISelector<ViewerUIElement>(ElementKind.Tree, (IUIPlayer)player, ViewerUIElement.class).parent(this.element);
        this.selector.table = new UISelector<ViewerUIElement>(ElementKind.Table, (IUIPlayer)player, ViewerUIElement.class).parent(this.element);
        this.selector.list = new UISelector<ViewerUIElement>(ElementKind.List, (IUIPlayer)player, ViewerUIElement.class).parent(this.element);
        this.selector.tabItem = new UISelector<CompositeUIElement>(ElementKind.TabItem, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.tabFolder = new UISelector<PartUIElement>(ElementKind.TabFolder, (IUIPlayer)player, PartUIElement.class).parent(this.element);
        this.selector.view = new UISelector<PartUIElement>(ElementKind.View, (IUIPlayer)player, PartUIElement.class).parent(this.element);
        this.selector.editor = new UISelector<EditorUIElement>(ElementKind.Editor, (IUIPlayer)player, EditorUIElement.class).parent(this.element);
        this.selector.link = new UISelector<ControlUIElement>(ElementKind.Link, (IUIPlayer)player, ControlUIElement.class).parent(this.element);
        this.selector.diagramViewer = new UISelector<DiagramViewerUIElement>(ElementKind.DiagramViewer, (IUIPlayer)player, DiagramViewerUIElement.class).parent(this.element);
        this.selector.paletteViewer = new UISelector<DiagramViewerUIElement>(ElementKind.PaletteViewer, (IUIPlayer)player, DiagramViewerUIElement.class).parent(this.element);
        this.selector.expandable = new UISelector<CompositeUIElement>(ElementKind.Expandable, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.group = new UISelector<CompositeUIElement>(ElementKind.Group, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.cbanner = new UISelector<CompositeUIElement>(ElementKind.CBanner, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.coolbar = new UISelector<CompositeUIElement>(ElementKind.CoolBar, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.toolbar = new UISelector<CompositeUIElement>(ElementKind.Toolbar, (IUIPlayer)player, CompositeUIElement.class).parent(this.element);
        this.selector.any = new UISelector<ControlUIElement>(ElementKind.Any, (IUIPlayer)player, ControlUIElement.class).parent(this.element);
        this.selector.canvas = new UISelector<CanvasUIElement>(ElementKind.Canvas, (IUIPlayer)player, CanvasUIElement.class).parent(this.element);
    }

    public ControlUIElement button() {
        return this.selector.button.find();
    }

    public ControlUIElement any(int index) {
        return this.selector.any.find(index);
    }

    public CanvasUIElement canvas() {
        return this.selector.canvas.find();
    }

    public CanvasUIElement canvas(int index) {
        return this.selector.canvas.find(index);
    }

    public ControlUIElement button(String text) {
        return this.selector.button.find(text);
    }

    public ControlUIElement button(int index) {
        return this.selector.button.find(index);
    }

    public ControlUIElement button(String text, int index) {
        return this.selector.button.find(text, index);
    }

    public CompositeUIElement group() {
        return this.selector.group.find();
    }

    public CompositeUIElement group(String text) {
        return this.selector.group.find(text);
    }

    public CompositeUIElement group(int index) {
        return this.selector.group.find(index);
    }

    public CompositeUIElement expandable() {
        return this.selector.expandable.find();
    }

    public CompositeUIElement expandable(String text) {
        return this.selector.expandable.find(text);
    }

    public CompositeUIElement expandable(int index) {
        return this.selector.expandable.find(index);
    }

    public CompositeUIElement expandable(String text, int index) {
        return this.selector.expandable.find(text, index);
    }

    public ControlUIElement link() {
        return this.selector.link.find();
    }

    public ControlUIElement link(String text) {
        return this.selector.link.find(text);
    }

    public ControlUIElement link(int index) {
        return this.selector.link.find(index);
    }

    public ControlUIElement label() {
        return this.selector.label.find();
    }

    public ControlUIElement label(String text) {
        return this.selector.label.find(text);
    }

    public ControlUIElement label(int index) {
        return this.selector.label.find(index);
    }

    public TextUIElement text() {
        return this.selector.text.find();
    }

    public TextUIElement text(int index) {
        return this.selector.text.find(index);
    }

    public TextUIElement combo() {
        return this.selector.combo.find();
    }

    public TextUIElement combo(int index) {
        return this.selector.combo.find(index);
    }

    public FormTextUIElement formText() {
        return this.selector.formText.find();
    }

    public FormTextUIElement formText(String pattern) {
        return this.selector.formText.find(pattern);
    }

    public FormTextUIElement formText(int index) {
        return this.selector.formText.find(index);
    }

    public ViewerUIElement tree() {
        return this.selector.tree.find();
    }

    public ViewerUIElement tree(int index) {
        return this.selector.tree.find(index);
    }

    public ViewerUIElement list() {
        return this.selector.list.find();
    }

    public ViewerUIElement list(int index) {
        return this.selector.list.find(index);
    }

    public ViewerUIElement table() {
        return this.selector.table.find();
    }

    public ViewerUIElement table(int index) {
        return this.selector.table.find(index);
    }

    public CompositeUIElement tabItem(String pattern) {
        return this.selector.tabItem.find(pattern);
    }

    public PartUIElement tabFolder() {
        return this.selector.tabFolder.find();
    }

    public PartUIElement tabFolder(int index) {
        return this.selector.tabFolder.find(index);
    }

    public PartUIElement view(String pattern) {
        return this.selector.view.find(pattern);
    }

    public PartUIElement view(String pattern, int index) {
        return this.selector.view.find(pattern, index);
    }

    public EditorUIElement editor(String pattern) {
        return this.selector.editor.find(pattern);
    }

    public EditorUIElement editor(String pattern, String classPattern, Integer index) {
        return this.selector.editor.classPattern(classPattern).find(pattern, index);
    }

    public DiagramViewerUIElement diagramViewer() {
        return this.diagramViewer(null);
    }

    public DiagramViewerUIElement diagramViewer(Integer index) {
        return this.selector.diagramViewer.find(index);
    }

    public DiagramViewerUIElement paletteViewer() {
        return this.selector.paletteViewer.find();
    }

    public CompositeUIElement coolbar() {
        return this.selector.coolbar.find();
    }

    public CompositeUIElement coolbar(int index) {
        return this.selector.coolbar.find(index);
    }

    public CompositeUIElement cbanner() {
        return this.selector.cbanner.find();
    }

    public ControlUIElement cbanner(int index) {
        return this.selector.cbanner.find(index);
    }

    public CompositeUIElement toolbar() {
        return this.selector.toolbar.find();
    }

    public CompositeUIElement toolbar(int index) {
        return this.selector.toolbar.find(index);
    }

    public CompositeUIElement after(Element e) {
        CompositeUIElement ee = new CompositeUIElement(this.element, this.player);
        ee.updateAfter(e);
        return ee;
    }

    public CompositeUIElement after(BasicUIElement e) {
        CompositeUIElement ee = new CompositeUIElement(this.element, this.player);
        Assert.isNotNull((Object)e);
        Assert.isNotNull((Object)e.getElement());
        ee.updateAfter(e.getElement());
        return ee;
    }

    public CompositeUIElement after(UISelector<BasicUIElement> selector) {
        CompositeUIElement ee = new CompositeUIElement(this.element, this.player);
        BasicUIElement select = selector.find();
        Assert.isNotNull((Object)select);
        Assert.isNotNull((Object)select.getElement());
        ee.updateAfter(select.getElement());
        return ee;
    }

    private static class Selectors {
        public UISelector<ControlUIElement> button;
        public UISelector<ControlUIElement> label;
        public UISelector<CompositeUIElement> group;
        public UISelector<CompositeUIElement> expandable;
        public UISelector<TextUIElement> text;
        public UISelector<TextUIElement> combo;
        public UISelector<ViewerUIElement> tree;
        public UISelector<ViewerUIElement> list;
        public UISelector<ViewerUIElement> table;
        public UISelector<CompositeUIElement> tabItem;
        public UISelector<PartUIElement> tabFolder;
        public UISelector<PartUIElement> view;
        public UISelector<EditorUIElement> editor;
        public UISelector<FormTextUIElement> formText;
        public UISelector<ControlUIElement> link;
        public UISelector<DiagramViewerUIElement> diagramViewer;
        public UISelector<DiagramViewerUIElement> paletteViewer;
        public UISelector<CompositeUIElement> cbanner;
        public UISelector<CompositeUIElement> coolbar;
        public UISelector<CompositeUIElement> toolbar;
        public UISelector<ControlUIElement> any;
        public UISelector<CanvasUIElement> canvas;

        private Selectors() {
        }
    }
}

