/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryResourceElement;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;

public class SelectionDragAdapter
implements DragSourceListener {
    private final LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
    private final TextTransfer textTransfer = TextTransfer.getInstance();
    private final Viewer viewer;

    public SelectionDragAdapter(Viewer viewer) {
        this.viewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.viewer.getSelection();
        this.selectionTransfer.setSelection(selection);
        this.selectionTransfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        event.doit = !selection.isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.textTransfer.isSupportedType(event.dataType)) {
            ISelection selection = this.selectionTransfer.getSelection();
            for (Object item : (IStructuredSelection)selection) {
                if (item instanceof RepositoryBundle) {
                    RepositoryBundle rb = (RepositoryBundle)item;
                    event.data = rb.getResource().toString();
                    break;
                }
                if (item instanceof RepositoryBundleVersion) {
                    RepositoryBundleVersion rbv = (RepositoryBundleVersion)item;
                    event.data = rbv.getResource().toString();
                    break;
                }
                if (!(item instanceof RepositoryResourceElement)) continue;
                RepositoryResourceElement rbe = (RepositoryResourceElement)item;
                event.data = rbe.getResource().toString();
                break;
            }
            return;
        }
        event.data = this.selectionTransfer.getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        this.selectionTransfer.setSelection(null);
        this.selectionTransfer.setSelectionSetTime(0L);
    }
}

