/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class LaunchProxy
extends AbstractModelProxy
implements ILaunchesListener2 {
    private ILaunch fLaunch;
    private final Set<Object> fPrevChildren = new HashSet<Object>();

    public LaunchProxy(ILaunch launch) {
        this.fLaunch = launch;
    }

    @Override
    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    @Override
    public void installed(Viewer viewer) {
        this.installModelProxies();
    }

    @Override
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        this.fPrevChildren.clear();
        this.fLaunch = null;
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch == this.fLaunch) {
                this.fireDelta(0x800C00);
                break;
            }
            ++n2;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch == this.fLaunch) {
                this.fireDelta(0x800000);
                break;
            }
            ++n2;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch == this.fLaunch) {
                this.fireDelta(3072);
                this.installModelProxies();
                break;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installModelProxies() {
        boolean changes = false;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        Object[] allLaunches = manager.getLaunches();
        ModelDelta root = new ModelDelta(manager, 0, 0, allLaunches.length);
        LaunchProxy launchProxy = this;
        synchronized (launchProxy) {
            Object[] children = this.fLaunch.getChildren();
            ModelDelta launchDelta = root.addNode(this.fLaunch, this.indexOf(this.fLaunch, allLaunches), 0x100000, children.length);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.fPrevChildren.add(child)) {
                    changes = true;
                    launchDelta.addNode(child, this.indexOf(child, children), 0x400000, -1);
                }
                ++n2;
            }
            List<Object> childrenList = Arrays.asList(children);
            Iterator<Object> itr = this.fPrevChildren.iterator();
            while (itr.hasNext()) {
                Object child = itr.next();
                if (childrenList.contains(child)) continue;
                itr.remove();
                changes = true;
                launchDelta.addNode(child, 0x800000);
            }
        }
        if (changes) {
            this.fireModelChanged(root);
        }
    }

    protected int indexOf(Object element, Object[] list) {
        int i = 0;
        while (i < list.length) {
            if (element == list[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void fireDelta(int flags) {
        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
        delta.addNode(this.fLaunch, flags);
        this.fireModelChanged(delta);
    }
}

