/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.ui.navigator.ImageDescriptorRegistry;
import org.eclipse.rcptt.ui.navigator.ImageImageDescriptor;
import org.eclipse.rcptt.ui.navigator.Q7ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private ListenerList fListeners;

    public ProblemsLabelDecorator() {
        this(null);
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        if (image == null) {
            return null;
        }
        if (obj instanceof IResource) {
            try {
                int adornmentFlags = this.getErrorTicksFromMarkers((IResource)obj, 2);
                if (adornmentFlags != 0) {
                    ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
                    Rectangle bounds = image.getBounds();
                    return this.getRegistry().get((ImageDescriptor)new Q7ImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int severity = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null && markers.length > 0) {
            int i = 0;
            while (i < markers.length && severity != 2) {
                IMarker curr = markers[i];
                int val = curr.getAttribute("severity", -1);
                if (val == 1 || val == 2) {
                    severity = val;
                }
                ++i;
            }
        }
        return severity;
    }

    public void dispose() {
        if (this.fRegistry != null) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IResource) {
            try {
                int adornmentFlags = this.getErrorTicksFromMarkers((IResource)element, 2);
                if (adornmentFlags == 2) {
                    decoration.addOverlay(Images.getImageDescriptor("icons/overlay/error_co.gif"));
                } else if (adornmentFlags == 1) {
                    decoration.addOverlay(Images.getImageDescriptor("icons/overlay/warning_co.gif"));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

