/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.pde.internal.core.PDECore;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaUtil {
    public static URLConnection getURLConnection(URL url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new MalformedURLException("URL specified is null");
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        return connection;
    }

    public static void parseURL(URL url, DefaultHandler handler) {
        URLConnection connection = null;
        try {
            try {
                connection = SchemaUtil.getURLConnection(url);
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream input = connection.getInputStream();){
                    SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
                    parser.parse(input, handler);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (MalformedURLException | SAXException exception) {
                try {
                    if (connection instanceof JarURLConnection) {
                        ((JarURLConnection)connection).getJarFile().close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException | FactoryConfigurationError | ParserConfigurationException e) {
                PDECore.logException(e);
                try {
                    if (connection instanceof JarURLConnection) {
                        ((JarURLConnection)connection).getJarFile().close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (connection instanceof JarURLConnection) {
                    ((JarURLConnection)connection).getJarFile().close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

