/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class DirectoryApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private Map<String, String> fPackages;
    private String[] fPackageNames;

    public DirectoryApiTypeContainer(IApiElement parent, String location) {
        super(parent, 3, location);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.init();
            var6_3 = packageNames = this.getPackageNames();
            var5_4 = packageNames.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                pkg = var6_3[var4_5];
                if (visitor.visitPackage(pkg)) {
                    location = this.fPackages.get(pkg);
                    if (location != null && (dir = new File(location)).exists()) {
                        files = dir.listFiles((FileFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;)Z, lambda$0(java.io.File ), (Ljava/io/File;)Z)());
                        if (files != null) {
                            classFiles = new ArrayList<LocalApiTypeRoot>();
                            var14_15 = files;
                            var13_14 = files.length;
                            var12_13 = 0;
                            while (var12_13 < var13_14) {
                                file = var14_15[var12_13];
                                name = file.getName();
                                typeName = name.substring(0, name.length() - 6);
                                if (pkg.length() > 0) {
                                    typeName = pkg + "." + (String)typeName;
                                }
                                classFiles.add(new LocalApiTypeRoot(this, file.getAbsolutePath(), (String)typeName));
                                ++var12_13;
                            }
                            Collections.sort(classFiles);
                            for (IApiTypeRoot classFile : classFiles) {
                                visitor.visit(pkg, classFile);
                                visitor.end(pkg, classFile);
                            }
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 4 sources

                {
                    visitor.endVisitPackage(pkg);
                }
                ++var4_5;
            }
        }
        visitor.end(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Directory Class File Container: " + this.getName());
        return buff.toString();
    }

    @Override
    public synchronized void close() throws CoreException {
        this.fPackages = null;
        this.fPackageNames = null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        File file;
        String location;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((location = this.fPackages.get(pkg)) != null && (file = new File(location, cfName + ".class")).exists()) {
            return new LocalApiTypeRoot(this, file.getAbsolutePath(), qualifiedName);
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        this.init();
        if (this.fPackageNames == null) {
            this.fPackageNames = (String[])this.fPackages.keySet().stream().sorted().toArray(String[]::new);
        }
        return this.fPackageNames;
    }

    private synchronized void init() {
        if (this.fPackages == null) {
            this.fPackages = new HashMap<String, String>();
            this.processDirectory("", new File(this.getName()));
        }
    }

    private void processDirectory(String packageName, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            boolean hasClassFiles = false;
            ArrayList<File> dirs = new ArrayList<File>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file.getAbsoluteFile());
                } else if (!hasClassFiles && file.getName().endsWith(".class")) {
                    this.fPackages.put(packageName, dir.getAbsolutePath());
                    hasClassFiles = true;
                }
                ++n2;
            }
            for (File child : dirs) {
                Object nextName = null;
                nextName = packageName.length() == 0 ? child.getName() : packageName + "." + child.getName();
                this.processDirectory((String)nextName, child);
            }
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 2;
    }

    private static /* synthetic */ boolean lambda$0(File file) {
        return file.isFile() && file.getName().endsWith(".class");
    }

    static class LocalApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable<Object> {
        String fLocation = null;

        public LocalApiTypeRoot(DirectoryApiTypeContainer directory, String location, String typeName) {
            super(directory, typeName);
            this.fLocation = location;
        }

        @Override
        public String getTypeName() {
            return this.getName();
        }

        @Override
        public int compareTo(Object o) {
            return this.getName().compareTo(((LocalApiTypeRoot)o).getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalApiTypeRoot) {
                return ((LocalApiTypeRoot)obj).getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public byte[] getContents() throws CoreException {
            try {
                return Files.readAllBytes(new File(this.fLocation).toPath());
            }
            catch (FileNotFoundException e) {
                this.abort("File not found", e);
                return null;
            }
            catch (IOException ioe) {
                this.abort("Unable to read class file: " + this.getTypeName(), ioe);
                return null;
            }
        }
    }
}

