/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.Changeset;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.nativerdf.ContextStore;
import org.eclipse.rdf4j.sail.nativerdf.NamespaceStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeEvaluationStatistics;
import org.eclipse.rdf4j.sail.nativerdf.NativeStatementIterator;
import org.eclipse.rdf4j.sail.nativerdf.TripleStore;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeSailStore
implements SailStore {
    final Logger logger = LoggerFactory.getLogger(NativeSailStore.class);
    private final TripleStore tripleStore;
    private final ValueStore valueStore;
    private final NamespaceStore namespaceStore;
    private final ContextStore contextStore;
    private final ReentrantLock sinkStoreAccessLock = new ReentrantLock();
    private final AtomicBoolean storeTxnStarted = new AtomicBoolean(false);

    public NativeSailStore(File dataDir, String tripleIndexes) throws IOException, SailException {
        this(dataDir, tripleIndexes, false, 512, 128, 64, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeSailStore(File dataDir, String tripleIndexes, boolean forceSync, int valueCacheSize, int valueIDCacheSize, int namespaceCacheSize, int namespaceIDCacheSize) throws IOException, SailException {
        boolean initialized = false;
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(dataDir, forceSync, valueCacheSize, valueIDCacheSize, namespaceCacheSize, namespaceIDCacheSize);
            this.tripleStore = new TripleStore(dataDir, tripleIndexes, forceSync);
            this.contextStore = new ContextStore(this, dataDir);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.close();
            }
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SailException {
        try {
            try {
                if (this.namespaceStore != null) {
                    this.namespaceStore.close();
                }
            }
            finally {
                try {
                    if (this.contextStore != null) {
                        this.contextStore.close();
                    }
                }
                finally {
                    try {
                        if (this.valueStore != null) {
                            this.valueStore.close();
                        }
                    }
                    finally {
                        if (this.tripleStore != null) {
                            this.tripleStore.close();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to close store", (Throwable)e);
            throw new SailException(e);
        }
    }

    @Override
    public EvaluationStatistics getEvaluationStatistics() {
        return new NativeEvaluationStatistics(this.valueStore, this.tripleStore);
    }

    @Override
    public SailSource getExplicitSailSource() {
        return new NativeSailSource(true);
    }

    @Override
    public SailSource getInferredSailSource() {
        return new NativeSailSource(false);
    }

    List<Integer> getContextIDs(Resource ... contexts) throws IOException {
        assert (contexts.length > 0) : "contexts must not be empty";
        LinkedHashSet contextSet = new LinkedHashSet();
        Collections.addAll(contextSet, contexts);
        ArrayList<Integer> contextIDs = new ArrayList<Integer>(contextSet.size());
        for (Resource context : contextSet) {
            if (context == null) {
                contextIDs.add(0);
                continue;
            }
            int contextID = this.valueStore.getID(context);
            if (contextID == -1) continue;
            contextIDs.add(contextID);
        }
        return contextIDs;
    }

    CloseableIteration<Resource> getContexts() throws IOException {
        RecordIterator btreeIter = this.tripleStore.getAllTriplesSortedByContext(false);
        CloseableIteration<Statement> stIter1 = btreeIter == null ? this.createStatementIterator(null, null, null, true, new Resource[0]) : new NativeStatementIterator(btreeIter, this.valueStore);
        FilterIteration<Statement> stIter2 = new FilterIteration<Statement>((CloseableIteration)stIter1){

            @Override
            protected boolean accept(Statement st) {
                return st.getContext() != null;
            }

            @Override
            protected void handleClose() {
            }
        };
        return new ConvertingIteration<Statement, Resource>((CloseableIteration)stIter2){

            @Override
            protected Resource convert(Statement sourceObject) throws SailException {
                return sourceObject.getContext();
            }
        };
    }

    CloseableIteration<? extends Statement> createStatementIterator(Resource subj, IRI pred, Value obj, boolean explicit, Resource ... contexts) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return new EmptyIteration();
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return new EmptyIteration();
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return new EmptyIteration();
        }
        ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1);
        } else {
            for (Resource context : contexts) {
                int contextID;
                if (context == null) {
                    contextIDList.add(0);
                    continue;
                }
                if (context.isTriple() || (contextID = this.valueStore.getID(context)) == -1) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<NativeStatementIterator> perContextIterList = new ArrayList<NativeStatementIterator>(contextIDList.size());
        Iterator iterator = contextIDList.iterator();
        while (iterator.hasNext()) {
            int contextID = (Integer)iterator.next();
            RecordIterator btreeIter = this.tripleStore.getTriples(subjID, predID, objID, contextID, explicit, false);
            perContextIterList.add(new NativeStatementIterator(btreeIter, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    double cardinality(Resource subj, IRI pred, Value obj, Resource context) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return 0.0;
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return 0.0;
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return 0.0;
        }
        int contextID = -1;
        if (context != null && (contextID = this.valueStore.getID(context)) == -1) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }

    public void disableTxnStatus() {
        this.tripleStore.disableTxnStatus();
    }

    private final class NativeSailSource
    extends BackingSailSource {
        private final boolean explicit;

        public NativeSailSource(boolean explicit) {
            this.explicit = explicit;
        }

        @Override
        public SailSource fork() {
            throw new UnsupportedOperationException("This store does not support multiple datasets");
        }

        @Override
        public SailSink sink(IsolationLevel level) throws SailException {
            return new NativeSailSink(this.explicit);
        }

        @Override
        public NativeSailDataset dataset(IsolationLevel level) throws SailException {
            return new NativeSailDataset(this.explicit);
        }
    }

    private final class NativeSailDataset
    implements SailDataset {
        private final boolean explicit;

        public NativeSailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        @Override
        public void close() {
        }

        @Override
        public String getNamespace(String prefix) throws SailException {
            return NativeSailStore.this.namespaceStore.getNamespace(prefix);
        }

        @Override
        public CloseableIteration<? extends Namespace> getNamespaces() {
            return new CloseableIteratorIteration<SimpleNamespace>(NativeSailStore.this.namespaceStore.iterator());
        }

        @Override
        public CloseableIteration<? extends Resource> getContextIDs() throws SailException {
            return new CloseableIteratorIteration<Resource>(NativeSailStore.this.contextStore.iterator());
        }

        @Override
        public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            try {
                return NativeSailStore.this.createStatementIterator(subj, pred, obj, this.explicit, contexts);
            }
            catch (IOException e) {
                throw new SailException("Unable to get statements", e);
            }
        }
    }

    private final class NativeSailSink
    implements SailSink {
        private final boolean explicit;

        public NativeSailSink(boolean explicit) throws SailException {
            this.explicit = explicit;
        }

        @Override
        public void close() {
        }

        @Override
        public void prepare() throws SailException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void flush() throws SailException {
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                try {
                    NativeSailStore.this.valueStore.sync();
                }
                finally {
                    try {
                        NativeSailStore.this.namespaceStore.sync();
                    }
                    finally {
                        try {
                            NativeSailStore.this.contextStore.sync();
                        }
                        finally {
                            if (NativeSailStore.this.storeTxnStarted.get()) {
                                NativeSailStore.this.tripleStore.commit();
                                NativeSailStore.this.storeTxnStarted.set(false);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                throw new SailException(e);
            }
            catch (RuntimeException e) {
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
                if (e instanceof SailException) {
                    throw e;
                }
                throw new SailException(e);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public void setNamespace(String prefix, String name) throws SailException {
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTriplestoreTransaction();
                NativeSailStore.this.namespaceStore.setNamespace(prefix, name);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public void removeNamespace(String prefix) throws SailException {
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTriplestoreTransaction();
                NativeSailStore.this.namespaceStore.removeNamespace(prefix);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public void clearNamespaces() throws SailException {
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTriplestoreTransaction();
                NativeSailStore.this.namespaceStore.clear();
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        }

        @Override
        public void observeAll(Set<Changeset.SimpleStatementPattern> observed) {
        }

        @Override
        public void clear(Resource ... contexts) throws SailException {
            this.removeStatements(null, null, null, this.explicit, contexts);
        }

        @Override
        public void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
            try {
                this.addStatement(subj, pred, obj, this.explicit, ctx);
            }
            catch (RuntimeException e) {
                if (e instanceof SailException) {
                    throw e;
                }
                throw new SailException(e);
            }
        }

        @Override
        public void approveAll(Set<Statement> approved, Set<Resource> approvedContexts) {
            NativeSailStore.this.sinkStoreAccessLock.lock();
            this.startTriplestoreTransaction();
            try {
                for (Statement statement : approved) {
                    boolean wasNew;
                    Resource subj = statement.getSubject();
                    IRI pred = statement.getPredicate();
                    Value obj = statement.getObject();
                    Resource context = statement.getContext();
                    int subjID = NativeSailStore.this.valueStore.storeValue(subj);
                    int predID = NativeSailStore.this.valueStore.storeValue(pred);
                    int objID = NativeSailStore.this.valueStore.storeValue(obj);
                    int contextID = 0;
                    if (context != null) {
                        contextID = NativeSailStore.this.valueStore.storeValue(context);
                    }
                    if (!(wasNew = NativeSailStore.this.tripleStore.storeTriple(subjID, predID, objID, contextID, this.explicit)) || context == null) continue;
                    NativeSailStore.this.contextStore.increment(context);
                }
            }
            catch (IOException e) {
                throw new SailException(e);
            }
            catch (RuntimeException e) {
                if (e instanceof SailException) {
                    throw e;
                }
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
                throw new SailException(e);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public void deprecate(Statement statement) throws SailException {
            this.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), this.explicit, statement.getContext());
        }

        private synchronized void startTriplestoreTransaction() throws SailException {
            if (NativeSailStore.this.storeTxnStarted.compareAndSet(false, true)) {
                try {
                    NativeSailStore.this.tripleStore.startTransaction();
                }
                catch (IOException e) {
                    NativeSailStore.this.storeTxnStarted.set(false);
                    throw new SailException(e);
                }
            }
        }

        private boolean addStatement(Resource subj, IRI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
            Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
            boolean result = false;
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTriplestoreTransaction();
                int subjID = NativeSailStore.this.valueStore.storeValue(subj);
                int predID = NativeSailStore.this.valueStore.storeValue(pred);
                int objID = NativeSailStore.this.valueStore.storeValue(obj);
                if (contexts.length == 0) {
                    contexts = new Resource[]{null};
                }
                for (Resource context : contexts) {
                    boolean wasNew;
                    int contextID = 0;
                    if (context != null) {
                        contextID = NativeSailStore.this.valueStore.storeValue(context);
                    }
                    if ((wasNew = NativeSailStore.this.tripleStore.storeTriple(subjID, predID, objID, contextID, explicit)) && context != null) {
                        NativeSailStore.this.contextStore.increment(context);
                    }
                    result |= wasNew;
                }
            }
            catch (IOException e) {
                throw new SailException(e);
            }
            catch (RuntimeException e) {
                if (e instanceof SailException) {
                    throw e;
                }
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
                throw new SailException(e);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
            return result;
        }

        private long removeStatements(Resource subj, IRI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
            Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
            NativeSailStore.this.sinkStoreAccessLock.lock();
            try {
                this.startTriplestoreTransaction();
                int subjID = -1;
                if (subj != null && (subjID = NativeSailStore.this.valueStore.getID(subj)) == -1) {
                    long l = 0L;
                    return l;
                }
                int predID = -1;
                if (pred != null && (predID = NativeSailStore.this.valueStore.getID(pred)) == -1) {
                    long l = 0L;
                    return l;
                }
                int objID = -1;
                if (obj != null && (objID = NativeSailStore.this.valueStore.getID(obj)) == -1) {
                    long l = 0L;
                    return l;
                }
                int[] contextIds = new int[contexts.length == 0 ? 1 : contexts.length];
                if (contexts.length == 0) {
                    contextIds[0] = -1;
                } else {
                    for (int i = 0; i < contexts.length; ++i) {
                        int id;
                        Resource context = contexts[i];
                        contextIds[i] = context == null ? 0 : ((id = NativeSailStore.this.valueStore.getID(context)) != -1 ? id : Integer.MIN_VALUE);
                    }
                }
                long removeCount = 0L;
                for (int contextId : contextIds) {
                    Map<Integer, Long> result = NativeSailStore.this.tripleStore.removeTriplesByContext(subjID, predID, objID, contextId, explicit);
                    for (Map.Entry<Integer, Long> entry : result.entrySet()) {
                        Integer entryContextId = entry.getKey();
                        if (entryContextId > 0) {
                            Resource modifiedContext = (Resource)((Object)NativeSailStore.this.valueStore.getValue(entryContextId));
                            NativeSailStore.this.contextStore.decrementBy(modifiedContext, entry.getValue());
                        }
                        removeCount += entry.getValue().longValue();
                    }
                }
                long l = removeCount;
                return l;
            }
            catch (IOException e) {
                throw new SailException(e);
            }
            catch (RuntimeException e) {
                NativeSailStore.this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
                if (e instanceof SailException) {
                    throw e;
                }
                throw new SailException(e);
            }
            finally {
                NativeSailStore.this.sinkStoreAccessLock.unlock();
            }
        }

        @Override
        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            return this.removeStatements(subj, pred, obj, this.explicit, contexts) > 0L;
        }

        @Override
        public boolean supportsDeprecateByQuery() {
            return true;
        }
    }
}

