/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.event.base;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.event.NotifyingRepository;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionListener;
import org.eclipse.rdf4j.repository.event.RepositoryListener;
import org.eclipse.rdf4j.repository.event.base.NotifyingRepositoryConnectionWrapper;

public class NotifyingRepositoryWrapper
extends RepositoryWrapper
implements NotifyingRepository {
    private boolean activated;
    private boolean defaultReportDeltas = false;
    private final Set<RepositoryListener> listeners = new CopyOnWriteArraySet<RepositoryListener>();
    private final Set<RepositoryConnectionListener> conListeners = new CopyOnWriteArraySet<RepositoryConnectionListener>();

    public NotifyingRepositoryWrapper() {
    }

    public NotifyingRepositoryWrapper(Repository delegate) {
        super(delegate);
    }

    public NotifyingRepositoryWrapper(Repository delegate, boolean defaultReportDeltas) {
        this(delegate);
        this.setDefaultReportDeltas(defaultReportDeltas);
    }

    public boolean getDefaultReportDeltas() {
        return this.defaultReportDeltas;
    }

    public void setDefaultReportDeltas(boolean defaultReportDeltas) {
        this.defaultReportDeltas = defaultReportDeltas;
    }

    @Override
    public void addRepositoryListener(RepositoryListener listener) {
        this.listeners.add(listener);
        this.activated = true;
    }

    @Override
    public void removeRepositoryListener(RepositoryListener listener) {
        this.listeners.remove(listener);
        this.activated = !this.listeners.isEmpty();
    }

    @Override
    public void addRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.conListeners.add(listener);
    }

    @Override
    public void removeRepositoryConnectionListener(RepositoryConnectionListener listener) {
        this.conListeners.remove(listener);
    }

    @Override
    public NotifyingRepositoryConnection getConnection() throws RepositoryException {
        RepositoryConnection con = this.getDelegate().getConnection();
        NotifyingRepositoryConnectionWrapper ncon = new NotifyingRepositoryConnectionWrapper(this, con, this.getDefaultReportDeltas());
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.getConnection(this, ncon);
            }
        }
        for (RepositoryConnectionListener l : this.conListeners) {
            ncon.addRepositoryConnectionListener(l);
        }
        return ncon;
    }

    public void init() throws RepositoryException {
        super.init();
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.init(this);
            }
        }
    }

    public void setDataDir(File dataDir) {
        super.setDataDir(dataDir);
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.setDataDir(this, dataDir);
            }
        }
    }

    public void shutDown() throws RepositoryException {
        super.shutDown();
        if (this.activated) {
            for (RepositoryListener listener : this.listeners) {
                listener.shutDown(this);
            }
        }
    }
}

