/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.base;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public abstract class ScriptStatusContext
extends RefactoringStatusContext {
    public static RefactoringStatusContext create(IMember member) {
        if (member == null || !member.exists()) {
            return null;
        }
        return new MemberSourceContext(member);
    }

    public static RefactoringStatusContext create(ISourceModule cunit) {
        return ScriptStatusContext.create(cunit, null);
    }

    public static RefactoringStatusContext create(ISourceModule cunit, ISourceRange range) {
        if (cunit == null) {
            return null;
        }
        return new SourceModuleSourceContext(cunit, range);
    }

    public static RefactoringStatusContext create(ISourceModule cunit, ASTNode node) {
        SourceRange range = null;
        if (node != null) {
            range = new SourceRange(node.sourceStart(), node.sourceEnd());
        }
        return ScriptStatusContext.create(cunit, range);
    }

    public abstract boolean isBinary();

    public abstract ISourceModule getSourceModule();

    public abstract ISourceRange getSourceRange();

    public Object getCorrespondingElement() {
        return this.getSourceModule();
    }

    private static class MemberSourceContext
    extends ScriptStatusContext {
        private IMember fMember;

        private MemberSourceContext(IMember member) {
            this.fMember = member;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public ISourceModule getSourceModule() {
            return this.fMember.getSourceModule();
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (ModelException e) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class SourceModuleSourceContext
    extends ScriptStatusContext {
        private ISourceModule fCUnit;
        private ISourceRange fSourceRange;

        private SourceModuleSourceContext(ISourceModule cunit, ISourceRange range) {
            this.fCUnit = cunit;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public ISourceModule getSourceModule() {
            return this.fCUnit;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return String.valueOf(this.getSourceRange()) + " in " + super.toString();
        }
    }
}

