/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.FieldInfo;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;

public class AuditListTableMapping
extends AbstractListTableMapping {
    private IDBField versionField;
    private String sqlClear;

    public AuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
    }

    @Override
    protected void initSQLStrings() {
        super.initSQLStrings();
        IDBTable table = this.getTable();
        this.versionField = table.getField(MappingNames.LIST_REVISION_VERSION);
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(table);
        builder.append(" WHERE ");
        builder.append(this.sourceField);
        builder.append("=? AND ");
        builder.append(this.versionField);
        builder.append("=?");
        this.sqlClear = builder.toString();
    }

    @Override
    protected void addKeyFields(List<FieldInfo> list) {
        list.add(new FieldInfo(MappingNames.LIST_REVISION_VERSION, DBType.INTEGER));
    }

    @Override
    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        idHandler.setCDOID(stmt, 1, revision.getID());
        stmt.setInt(2, revision.getVersion());
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        if (this.getTable() == null) {
            this.initTable(accessor);
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlClear, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, version);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }
}

