/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditorContextMenuProvider;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowTreePartFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PageflowEditorOutlinePage
extends Page
implements IContentOutlinePage {
    private final PageflowEditor editor;
    private PageflowElement outlineContent = null;
    private Canvas overview = null;
    private RootEditPart overviewContent = null;
    private ScrollableThumbnail thumbnail = null;
    private TreeViewer treeViewer = null;
    private Control outline = null;
    private PageBook pageBook = null;
    private IAction showOutlineAction = null;
    private IAction showOverviewAction = null;
    private LightweightSystem lws = null;
    private EditDomain editDomain = null;
    private final ViewerContentListener viewerContentListener = new ViewerContentListener();

    public PageflowEditorOutlinePage(EditorPart editor) {
        this.editor = (PageflowEditor)editor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().addSelectionChangedListener(listener);
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.outline = this.getTreeViewer().createControl((Composite)this.pageBook);
        this.configureEditPartViewer((EditPartViewer)this.getTreeViewer());
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.lws = new LightweightSystem(this.overview);
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.showOutlineAction = new Action(){

            public void run() {
                PageflowEditorOutlinePage.this.showPage(PageflowEditorOutlinePage.this.outline);
            }
        };
        this.showOutlineAction.setImageDescriptor(EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Outline.gif"));
        tbm.add(this.showOutlineAction);
        this.showOverviewAction = new Action(){

            public void run() {
                PageflowEditorOutlinePage.this.showPage((Control)PageflowEditorOutlinePage.this.overview);
            }
        };
        this.showOverviewAction.setImageDescriptor(EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Outline_Overview.gif"));
        tbm.add(this.showOverviewAction);
        this.initializeOutlineViewer();
        this.initializeOverview();
        this.showPage(this.outline);
    }

    private void initializeOutlineViewer() {
        if (this.getEditDomain() != null) {
            this.getEditDomain().addViewer((EditPartViewer)this.getTreeViewer());
        }
        this.editor.getSelectionSynchronizer().addViewer((EditPartViewer)this.getTreeViewer());
        this.getTreeViewer().setContents((Object)this.getOutlineContent());
    }

    protected void showPage(Control id) {
        if (id == this.outline) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (id == this.overview) {
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(true);
            }
        }
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public void dispose() {
        this.editor.getSelectionSynchronizer().removeViewer((EditPartViewer)this.getTreeViewer());
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        super.dispose();
    }

    private void initializeOverview() {
        if (this.lws == null) {
            return;
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        this.thumbnail = new ScrollableThumbnail();
        this.thumbnail.setBorder((Border)new MarginBorder(3));
        this.lws.setContents((IFigure)this.thumbnail);
        if (this.getOverviewContent() != null) {
            Viewport viewport = null;
            IFigure source = null;
            if (this.getOverviewContent() instanceof ScalableFreeformRootEditPart) {
                viewport = (Viewport)((ScalableFreeformRootEditPart)this.getOverviewContent()).getFigure();
                source = ((ScalableFreeformRootEditPart)this.getOverviewContent()).getLayer((Object)"Printable Layers");
            }
            if (this.getOverviewContent() instanceof ScalableRootEditPart) {
                viewport = (Viewport)((ScalableRootEditPart)this.getOverviewContent()).getFigure();
                source = ((ScalableRootEditPart)this.getOverviewContent()).getLayer((Object)"Printable Layers");
            }
            if (viewport != null && source != null) {
                this.thumbnail.setViewport(viewport);
                this.thumbnail.setSource(source);
            }
        }
    }

    public PageflowElement getOutlineContent() {
        return this.outlineContent;
    }

    public Control getControl() {
        return this.pageBook;
    }

    public RootEditPart getOverviewContent() {
        return this.overviewContent;
    }

    public ISelection getSelection() {
        return this.getTreeViewer().getSelection();
    }

    public TreeViewer getTreeViewer() {
        if (this.treeViewer == null) {
            this.treeViewer = new TreeViewer();
            this.treeViewer.setEditPartFactory((EditPartFactory)new PageflowTreePartFactory());
        }
        return this.treeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().removeSelectionChangedListener(listener);
    }

    public void setOutlineContent(PageflowElement element) {
        if (this.outlineContent != element) {
            this.outlineContent = element;
            if (this.getTreeViewer().getControl() != null) {
                this.getTreeViewer().setContents((Object)element);
                if (this.pageBook != null) {
                    if (this.showOverviewAction.isChecked()) {
                        this.showPage(this.outline);
                        this.showPage((Control)this.overview);
                    } else {
                        this.showPage(this.outline);
                    }
                }
            }
        }
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void setOverviewContent(RootEditPart part) {
        if (this.overviewContent != part) {
            this.overviewContent = part;
            this.initializeOverview();
        }
    }

    public void setSelection(ISelection selection) {
        this.getTreeViewer().setSelection(selection);
    }

    public void initialize(PageflowEditor newPage) {
        if (newPage.getGraphicalViewer() != null) {
            this.setOverviewContent(newPage.getGraphicalViewer().getRootEditPart());
            EditPart currentContent = newPage.getGraphicalViewer().getContents();
            this.setOutlineContent(currentContent != null ? (PageflowElement)currentContent.getModel() : null);
            this.setEditDomain((EditDomain)newPage.getEditDomain());
            this.getViewerContentListener().setViewer((EditPartViewer)newPage.getGraphicalViewer());
        } else {
            this.setOverviewContent(null);
            this.setOutlineContent(null);
            this.setEditDomain(null);
        }
    }

    public void setEditDomain(EditDomain domain) {
        if (this.editDomain != domain) {
            if (this.getTreeViewer() != null) {
                if (this.editDomain != null) {
                    this.editDomain.removeViewer((EditPartViewer)this.getTreeViewer());
                }
                if (domain != null) {
                    domain.addViewer((EditPartViewer)this.getTreeViewer());
                }
            }
            this.editDomain = domain;
        }
    }

    private ViewerContentListener getViewerContentListener() {
        return this.viewerContentListener;
    }

    protected void configureEditPartViewer(EditPartViewer viewer) {
        if (viewer.getKeyHandler() != null) {
            viewer.getKeyHandler().setParent(this.editor.getSharedKeyHandler());
        }
        PageflowEditorContextMenuProvider provider = new PageflowEditorContextMenuProvider(viewer, this.editor.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(EditorPlugin.getPluginId() + ".pageflow.editor.outlineview.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
    }

    private class ViewerContentListener
    implements EditPartListener {
        private EditPartViewer _viewer;

        private ViewerContentListener() {
        }

        public void setViewer(EditPartViewer viewer) {
            if (this._viewer != null) {
                this._viewer.getRootEditPart().removeEditPartListener((EditPartListener)this);
            }
            this._viewer = viewer;
            if (this._viewer != null) {
                this._viewer.getRootEditPart().addEditPartListener((EditPartListener)this);
            }
        }

        public void childAdded(EditPart child, int index) {
            if (child.getModel() instanceof PageflowElement) {
                PageflowEditorOutlinePage.this.setOutlineContent((PageflowElement)child.getModel());
            }
        }

        public void partActivated(EditPart editpart) {
        }

        public void partDeactivated(EditPart editpart) {
        }

        public void removingChild(EditPart child, int index) {
        }

        public void selectedStateChanged(EditPart editpart) {
        }
    }
}

