/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlag;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlagMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaTaskAttachmentPage
extends TaskAttachmentPage {
    private final List<BugzillaFlag> flagAttributes = new ArrayList<BugzillaFlag>();
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private ExpandableComposite flagExpandComposite = null;
    private Composite flagScrollComposite;
    private SectionComposite scrolledComposite;
    private Composite scrolledBodyComposite;

    public BugzillaTaskAttachmentPage(TaskAttachmentModel model) {
        super(model);
    }

    private void updateScrolledCompositeSize() {
        Point p = this.scrolledBodyComposite.computeSize(-1, -1, true);
        this.scrolledComposite.setMinSize(p);
        Shell shell = this.getShell();
        shell.pack();
        Point shellSize = shell.getSize();
        ++shellSize.x;
        shell.setSize(shellSize);
        --shellSize.x;
        shell.setSize(shellSize);
        shell.pack();
    }

    private void createScrolledComposite(Composite parent) {
        this.scrolledComposite = new SectionComposite(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(64, 64);
            }
        };
        this.scrolledBodyComposite = this.scrolledComposite.getContent();
        this.scrolledBodyComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setContent((Control)this.scrolledBodyComposite);
        this.setControl((Control)this.scrolledComposite);
        Dialog.applyDialogFont((Control)this.scrolledBodyComposite);
    }

    private Composite getScrolledBodyComposite() {
        return this.scrolledBodyComposite;
    }

    public void createControl(Composite parent) {
        this.createScrolledComposite(parent);
        this.updateScrolledCompositeSize();
        super.createControl(this.getScrolledBodyComposite());
        BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)this.getModel().getTaskRepository().getConnectorKind());
        RepositoryConfiguration configuration = connector.getRepositoryConfiguration(this.getModel().getTaskRepository().getRepositoryUrl());
        if (configuration != null) {
            List flags = configuration.getFlags();
            TaskAttribute productAttribute = this.getModel().getAttribute().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.PRODUCT.getKey());
            TaskAttribute componentAttribute = this.getModel().getAttribute().getTaskData().getRoot().getMappedAttribute(BugzillaAttribute.COMPONENT.getKey());
            Control[] children = this.getScrolledBodyComposite().getChildren();
            Composite pageComposite = (Composite)children[children.length - 1];
            Composite flagComposite = null;
            for (BugzillaFlag bugzillaFlag : flags) {
                if (bugzillaFlag.getType().equals("bug") || !bugzillaFlag.isUsedIn(productAttribute.getValue(), componentAttribute.getValue())) continue;
                if (flagComposite == null) {
                    flagComposite = this.createFlagSection(pageComposite);
                }
                BugzillaFlagMapper mapper = new BugzillaFlagMapper(connector);
                mapper.setRequestee("");
                mapper.setSetter("");
                mapper.setState(" ");
                mapper.setFlagId(bugzillaFlag.getName());
                mapper.setNumber(0);
                final TaskAttribute attribute = this.getModel().getAttribute().createAttribute("task.common.kind.flag_type" + bugzillaFlag.getFlagId());
                mapper.applyTo(attribute);
                Label flagLiteral = new Label(flagComposite, 0);
                flagLiteral.setText(bugzillaFlag.getName());
                flagLiteral.setToolTipText(bugzillaFlag.getDescription());
                this.flagAttributes.add(bugzillaFlag);
                final Combo flagState = new Combo(flagComposite, 2060);
                flagState.add(" ");
                if (bugzillaFlag.isRequestable()) {
                    flagState.add("?");
                }
                flagState.add("+");
                flagState.add("-");
                if (bugzillaFlag.isRequestable() && bugzillaFlag.isSpecifically_requestable()) {
                    flagState.setLayoutData((Object)new GridData(-1, -1, false, false, 1, 1));
                    final Text requesteeText = new Text(flagComposite, 2048);
                    requesteeText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
                    requesteeText.setEditable(false);
                    requesteeText.addModifyListener(e -> {
                        TaskAttribute requesteeAttribute = attribute.getAttribute("requestee");
                        if (requesteeAttribute != null) {
                            String value = requesteeText.getText().trim();
                            requesteeAttribute.setValue(value);
                        }
                    });
                    flagState.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            TaskAttribute state = attribute.getAttribute("state");
                            if (state != null) {
                                String value = flagState.getItem(flagState.getSelectionIndex());
                                state.setValue(value);
                                requesteeText.setEditable(value.equals("?"));
                            }
                        }
                    });
                    continue;
                }
                flagState.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
                flagState.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        TaskAttribute state = attribute.getAttribute("state");
                        String value = flagState.getItem(flagState.getSelectionIndex());
                        if (state != null && value != null) {
                            state.setValue(value);
                        }
                    }
                });
            }
        }
        this.updateScrolledCompositeSize();
    }

    private Composite createFlagSection(Composite container) {
        this.flagExpandComposite = this.toolkit.createExpandableComposite(container, 290);
        this.flagExpandComposite.setFont(container.getFont());
        this.flagExpandComposite.setBackground(container.getBackground());
        this.flagExpandComposite.setText(Messages.BugzillaTaskAttachmentPage_Advanced);
        this.flagExpandComposite.setLayout((Layout)new GridLayout(3, false));
        GridData g = new GridData(4, 128, true, false);
        g.horizontalSpan = 3;
        this.flagExpandComposite.setLayoutData((Object)g);
        this.flagExpandComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BugzillaTaskAttachmentPage.this.updateScrolledCompositeSize();
                BugzillaTaskAttachmentPage.this.getControl().getShell().pack();
            }
        });
        this.flagScrollComposite = new Composite((Composite)this.flagExpandComposite, 0);
        this.flagScrollComposite.setLayout((Layout)new GridLayout(3, false));
        this.flagExpandComposite.setClient((Control)this.flagScrollComposite);
        return this.flagScrollComposite;
    }

    public void dispose() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

