/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.gef.header.HeadersContainerEditPart;
import org.eclipse.wb.internal.core.gef.header.HeadersContextMenuProvider;
import org.eclipse.wb.internal.core.gef.header.HeadersEditPartFactory;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.internal.gef.graphical.HeaderGraphicalViewer;

public final class ViewersComposite
extends Composite {
    private static final int HEADER_SIZE = 15;
    private final GraphicalViewer m_viewer;
    private final HeaderGraphicalViewer m_horizontalViewer = new HeaderGraphicalViewer((Composite)this, true);
    private final HeaderGraphicalViewer m_verticalViewer = new HeaderGraphicalViewer((Composite)this, false);
    private HeadersContainerEditPart m_headersContainerHorizontal;
    private HeadersContainerEditPart m_headersContainerVertical;

    public ViewersComposite(Composite parent, int style) {
        super(parent, style);
        this.m_viewer = new GraphicalViewer(this);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ViewersComposite.this.layout();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                gc.setForeground(ColorConstants.buttonDarker);
                Rectangle clientArea = ViewersComposite.this.getClientArea();
                gc.drawLine(15, 15, clientArea.width, 15);
                gc.drawLine(15, 15, 15, clientArea.height);
            }
        });
        this.m_horizontalViewer.setContextMenu(new HeadersContextMenuProvider(this.m_horizontalViewer));
        this.m_verticalViewer.setContextMenu(new HeadersContextMenuProvider(this.m_verticalViewer));
    }

    public void bindViewers() {
        HeadersEditPartFactory editPartFactory = new HeadersEditPartFactory();
        this.m_horizontalViewer.setMainViewer(this.m_viewer);
        this.m_horizontalViewer.setEditPartFactory(editPartFactory);
        this.m_headersContainerHorizontal = new HeadersContainerEditPart(this.m_viewer, true);
        this.m_horizontalViewer.setInput(this.m_headersContainerHorizontal);
        this.m_verticalViewer.setMainViewer(this.m_viewer);
        this.m_verticalViewer.setEditPartFactory(editPartFactory);
        this.m_headersContainerVertical = new HeadersContainerEditPart(this.m_viewer, false);
        this.m_verticalViewer.setInput(this.m_headersContainerVertical);
    }

    public void setRoot(ObjectInfo rootObject) {
        rootObject.addBroadcastListener(new ObjectEventListener(){

            @Override
            public void refreshed2() throws Exception {
                ViewersComposite.this.m_headersContainerHorizontal.refreshHeaders();
                ViewersComposite.this.m_headersContainerVertical.refreshHeaders();
            }
        });
    }

    public GraphicalViewer getViewer() {
        return this.m_viewer;
    }

    public HeaderGraphicalViewer getHorizontalViewer() {
        return this.m_horizontalViewer;
    }

    public HeaderGraphicalViewer getVerticalViewer() {
        return this.m_verticalViewer;
    }

    public boolean setFocus() {
        return this.m_viewer.getControl().setFocus();
    }

    public void layout() {
        Rectangle clientArea = this.getClientArea();
        int x = 16;
        int y = 16;
        int width = clientArea.width - x;
        int height = clientArea.height - y;
        this.m_horizontalViewer.getControl().setBounds(x, 0, width, 15);
        this.m_verticalViewer.getControl().setBounds(0, y, 15, height);
        this.m_viewer.getControl().setBounds(x, y, width, height);
    }
}

