/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SeparatorBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProviders;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.IPropertyExceptionHandler;
import org.eclipse.wb.internal.core.model.property.table.PropertyTableTooltipHelper;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public class PropertyTable
extends ScrollingGraphicalViewer {
    private static final Color COLOR_BACKGROUND = ColorConstants.listBackground;
    private static final Color COLOR_NO_PROPERTIES = ColorConstants.gray;
    private static final Color COLOR_LINE = ColorConstants.lightGray;
    private static final Color COLOR_COMPLEX_LINE = DrawUtils.getShiftedColor(ColorConstants.lightGray, -32);
    private static final Color COLOR_PROPERTY_BG = DrawUtils.getShiftedColor(COLOR_BACKGROUND, -12);
    private static final Color COLOR_PROPERTY_BG_MODIFIED = COLOR_BACKGROUND;
    private static final Color COLOR_PROPERTY_FG_TITLE = ColorConstants.listForeground;
    private static final Color COLOR_PROPERTY_FG_VALUE = DrawUtils.isDarkColor(ColorConstants.listBackground) ? ColorConstants.lightBlue : ColorConstants.darkBlue;
    private static final Color COLOR_PROPERTY_BG_SELECTED = Display.getCurrent().getSystemColor(26);
    private static final Color COLOR_PROPERTY_FG_SELECTED = Display.getCurrent().getSystemColor(27);
    private static final Color COLOR_PROPERTY_FG_ADVANCED = ColorConstants.gray;
    private static final int MIN_COLUMN_WIDTH = 75;
    private static final int MARGIN_LEFT = 2;
    private static final int MARGIN_RIGHT = 1;
    private static final int MARGIN_BOTTOM = 1;
    private static final int STATE_IMAGE_MARGIN_RIGHT = 4;
    private static final Image m_plusImage = DesignerPlugin.getImage("properties/plus.gif");
    private static final Image m_minusImage = DesignerPlugin.getImage("properties/minus.gif");
    private static int m_stateWidth = 9;
    private boolean m_showAdvancedProperties;
    private Property[] m_rawProperties;
    private List<PropertyInfo> m_properties;
    private final Set<String> m_expandedIds = new TreeSet<String>();
    private int m_rowHeight;
    private int m_splitter = -1;
    private Font m_baseFont;
    private Font m_boldFont;
    private Font m_italicFont;
    private PropertyInfo m_activePropertyInfo;
    private String m_activePropertyId;
    private PropertyEditor m_activeEditor;
    private IPropertyExceptionHandler m_exceptionHandler;
    private PropertyCategoryProvider m_propertyCategoryProvider = PropertyCategoryProviders.fromProperty();

    public PropertyTable(Composite parent, int style) {
        this.createControl(parent);
        this.setEditPartFactory(new PropertyEditPartFactory());
        this.setEditDomain(new PropertyEditDomain());
        this.getControl().addListener(11, event -> this.handleResize());
        this.getControl().setScrollbarsMode(0);
        this.m_rowHeight = 1 + FigureUtilities.getFontMetrics((Font)this.getControl().getFont()).getHeight() + 1;
        this.m_baseFont = parent.getFont();
        this.m_boldFont = DrawUtils.getBoldFont(this.m_baseFont);
        this.m_italicFont = DrawUtils.getItalicFont(this.m_baseFont);
        this.setInput(null);
    }

    protected void handleDispose(DisposeEvent e) {
        this.m_boldFont.dispose();
        this.m_italicFont.dispose();
    }

    public FigureCanvas getControl() {
        return (FigureCanvas)super.getControl();
    }

    public PropertyEditDomain getEditDomain() {
        return (PropertyEditDomain)super.getEditDomain();
    }

    private void handleResize() {
        if (this.m_splitter <= 75) {
            this.m_splitter = Math.max((int)((double)this.getControl().getClientArea().width * 0.4), 75);
        }
        this.configureSplitter();
    }

    public void activateEditor(Property property, Point location) {
        try {
            this.deactivateEditor(true);
            PropertyEditor editor = property.getEditor();
            try {
                if (editor.activate(this, property, location)) {
                    this.m_activeEditor = editor;
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            this.setActiveEditorBounds();
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public void deactivateEditor(boolean save) {
        if (this.m_activeEditor != null) {
            PropertyEditor activeEditor = this.m_activeEditor;
            this.m_activeEditor = null;
            if (this.m_activePropertyInfo != null && this.m_activePropertyInfo.m_property != null) {
                activeEditor.deactivate(this, this.m_activePropertyInfo.m_property, save);
            }
        }
    }

    private void setActiveEditorBounds() {
        if (this.m_activeEditor != null) {
            int index = this.m_properties.indexOf(this.m_activePropertyInfo);
            if (index == -1) {
                this.deactivateEditor(true);
            } else {
                PropertyEditPart editPart = (PropertyEditPart)((Object)this.getEditPartRegistry().get(this.m_activePropertyInfo));
                Rectangle figureBounds = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart);
                int x = this.m_splitter + 1;
                int y = figureBounds.top();
                int width = this.getControl().getClientArea().width - x - 1;
                int height = figureBounds.height() - 1;
                org.eclipse.swt.graphics.Rectangle bounds = new org.eclipse.swt.graphics.Rectangle(x, y, width, height);
                this.m_activeEditor.setBounds(bounds);
            }
        }
    }

    public void setExceptionHandler(IPropertyExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public void handleException(Throwable e) {
        this.m_exceptionHandler.handle(e);
    }

    private int getTitleX(PropertyInfo propertyInfo) {
        return 2 + this.getLevelIndent() * propertyInfo.getLevel();
    }

    private int getTitleTextX(PropertyInfo propertyInfo) {
        return this.getTitleX(propertyInfo) + this.getLevelIndent();
    }

    private static Rectangle getAbsoluteBounds(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private int getLevelIndent() {
        return m_stateWidth + 4;
    }

    private void configureSplitter() {
        org.eclipse.swt.graphics.Rectangle clientArea = this.getControl().getClientArea();
        if (this.m_splitter < 75) {
            this.m_splitter = 75;
        }
        if (clientArea.width - this.m_splitter < 75) {
            this.m_splitter = clientArea.width - 75;
        }
    }

    private boolean isLocationState(PropertyInfo propertyInfo, int x) {
        int levelX = this.getTitleX(propertyInfo);
        return propertyInfo.isComplex() && levelX <= x && x <= levelX + m_stateWidth;
    }

    private boolean isLocationSplitter(int x) {
        return Math.abs(this.m_splitter - x) < 2;
    }

    private boolean isLocationValue(int x) {
        return x > this.m_splitter + 2;
    }

    private Point getValueRelativeLocation(int x, int y) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.findObjectAt(new Point(x, y));
        return new Point(x - (this.m_splitter + 2), PropertyTable.getAbsoluteBounds(editPart).top());
    }

    public void setShowAdvancedProperties(boolean showAdvancedProperties) {
        this.m_showAdvancedProperties = showAdvancedProperties;
        this.setInput0();
    }

    public void setInput(Property[] properties) {
        this.m_rawProperties = properties;
        this.setInput0();
    }

    private void setInput0() {
        if (this.m_properties != null) {
            for (PropertyInfo propertyInfo : this.m_properties) {
                Property property = propertyInfo.getProperty();
                PropertyEditorPresentation presentation = property.getEditor().getPresentation();
                if (presentation == null) continue;
                presentation.hide(this, property);
            }
        }
        if (this.m_rawProperties == null || this.m_rawProperties.length == 0) {
            this.deactivateEditor(false);
            this.m_properties = new ArrayList<PropertyInfo>();
        } else {
            try {
                boolean expanded;
                this.m_properties = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.m_rawProperties;
                int property = this.m_rawProperties.length;
                int n = 0;
                while (n < property) {
                    Property property2 = propertyArray[n];
                    if (this.rawProperties_shouldShow(property2)) {
                        PropertyInfo propertyInfo = new PropertyInfo(property2);
                        this.m_properties.add(propertyInfo);
                    }
                    ++n;
                }
                do {
                    expanded = false;
                    ArrayList<PropertyInfo> currentProperties = new ArrayList<PropertyInfo>(this.m_properties);
                    for (PropertyInfo propertyInfo : currentProperties) {
                        expanded |= propertyInfo.expandFromHistory();
                    }
                } while (expanded);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }
        if (this.m_activePropertyId != null) {
            PropertyInfo newActivePropertyInfo = null;
            if (this.m_properties != null) {
                for (PropertyInfo propertyInfo : this.m_properties) {
                    if (!propertyInfo.m_id.equals(this.m_activePropertyId)) continue;
                    newActivePropertyInfo = propertyInfo;
                    break;
                }
            }
            this.setActivePropertyInfo(newActivePropertyInfo);
        }
        this.setContents(this.m_properties);
    }

    private boolean rawProperties_shouldShow(Property property) throws Exception {
        PropertyCategory category = this.getCategory(property);
        if (category.isHidden()) {
            return false;
        }
        if (category.isAdvanced() && !this.m_showAdvancedProperties && !property.isModified()) {
            return false;
        }
        if (category.isAdvancedReally()) {
            return this.m_showAdvancedProperties;
        }
        return true;
    }

    public void setActiveProperty(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.m_property != property) continue;
            this.setActivePropertyInfo(propertyInfo);
            break;
        }
    }

    public int forTests_getPropertiesCount() {
        return this.m_properties.size();
    }

    public Property forTests_getProperty(int index) {
        return this.m_properties.get(index).getProperty();
    }

    public void forTests_expand(int index) throws Exception {
        this.m_properties.get(index).expand();
    }

    public int forTests_getSplitter() {
        return this.m_splitter;
    }

    public org.eclipse.swt.graphics.Point forTests_getStateLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            PropertyEditPart editPart = (PropertyEditPart)((Object)this.getEditPartRegistry().get(propertyInfo));
            int x = this.getTitleX(propertyInfo);
            int y = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart).y();
            return new org.eclipse.swt.graphics.Point(x, y);
        }
        return null;
    }

    public org.eclipse.swt.graphics.Point forTests_getValueLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            PropertyEditPart editPart = (PropertyEditPart)((Object)this.getEditPartRegistry().get(propertyInfo));
            int x = this.m_splitter + 5;
            int y = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart).y();
            return new org.eclipse.swt.graphics.Point(x, y);
        }
        return null;
    }

    public PropertyEditor forTests_getActiveEditor() {
        return this.m_activeEditor;
    }

    public PropertyCategory forTests_getCategory(Property property) {
        return this.getCategory(property);
    }

    private PropertyInfo getPropertyInfo(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.getProperty() != property) continue;
            return propertyInfo;
        }
        return null;
    }

    public ISelection getSelection() {
        if (this.m_activePropertyInfo != null) {
            return new StructuredSelection((Object)this.m_activePropertyInfo.getProperty());
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        throw new NotImplementedException(PropertyTable.class.getName());
    }

    private void setActivePropertyInfo(PropertyInfo activePropertyInfo) {
        Object v;
        this.m_activePropertyInfo = activePropertyInfo;
        if (this.m_activePropertyInfo != null) {
            this.m_activePropertyId = this.m_activePropertyInfo.m_id;
        }
        if ((v = this.getEditPartRegistry().get(this.m_activePropertyInfo)) instanceof PropertyEditPart) {
            PropertyEditPart editPart = (PropertyEditPart)((Object)v);
            this.reveal((EditPart)editPart);
        }
        this.fireSelectionChanged();
        this.getControl().redraw();
    }

    public void setPropertyCategoryProvider(PropertyCategoryProvider propertyCategoryProvider) {
        this.m_propertyCategoryProvider = propertyCategoryProvider;
    }

    private PropertyCategory getCategory(Property property) {
        return this.m_propertyCategoryProvider.getCategory(property);
    }

    private static class NoPropertyEditPart
    extends AbstractGraphicalEditPart {
        private NoPropertyEditPart() {
        }

        protected IFigure createFigure() {
            Label label = new Label();
            label.setBackgroundColor(COLOR_BACKGROUND);
            label.setForegroundColor(COLOR_NO_PROPERTIES);
            label.setText(ModelMessages.PropertyTable_noProperties);
            label.setOpaque(true);
            return label;
        }

        protected void createEditPolicies() {
        }
    }

    private final class PresentationFigure
    extends Figure {
        private final PropertyEditorPresentation m_presentation;
        private final Property m_property;

        public PresentationFigure(PropertyInfo propertyInfo) {
            this.m_property = propertyInfo.getProperty();
            this.m_presentation = this.m_property.getEditor().getPresentation();
            Objects.requireNonNull(this.m_presentation, "Property must have a presentation");
            this.setPreferredSize(this.m_presentation.getSize(-1, PropertyTable.this.m_rowHeight));
        }

        public void paintFigure(Graphics graphics) {
            Rectangle absoluteBounds = this.bounds.getCopy();
            this.translateToAbsolute((Translatable)absoluteBounds);
            this.m_presentation.show(PropertyTable.this, this.m_property, absoluteBounds.x, absoluteBounds.y, absoluteBounds.width, absoluteBounds.height);
        }

        public void erase() {
            this.m_presentation.hide(PropertyTable.this, this.m_property);
            super.erase();
        }
    }

    public class PropertyEditDomain
    extends EditDomain {
        private final PropertyTableTooltipHelper m_tooltipHelper;
        private boolean m_splitterResizing;
        private long m_lastExpandCollapseTime;

        public PropertyEditDomain() {
            this.m_tooltipHelper = new PropertyTableTooltipHelper(PropertyTable.this);
        }

        public void mouseDown(MouseEvent event, EditPartViewer viewer) {
            EditPart editPart;
            boolean bl = this.m_splitterResizing = event.button == 1 && PropertyTable.this.m_properties != null && PropertyTable.this.isLocationSplitter(event.x);
            if (!this.m_splitterResizing && (editPart = PropertyTable.this.findObjectAt(new Point(event.x, event.y))) instanceof PropertyEditPart) {
                PropertyEditPart editPart2 = (PropertyEditPart)editPart;
                PropertyTable.this.setActivePropertyInfo(editPart2.getModel());
                Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                PropertyTable.this.deactivateEditor(true);
                PropertyTable.this.getControl().redraw();
                if (PropertyTable.this.isLocationValue(event.x)) {
                    PropertyTable.this.activateEditor(property, PropertyTable.this.getValueRelativeLocation(event.x, event.y));
                }
            }
        }

        public void mouseUp(MouseEvent event, EditPartViewer viewer) {
            if (event.button == 1) {
                PropertyEditPart editPart;
                PropertyInfo propertyInfo;
                if (this.m_splitterResizing) {
                    this.m_splitterResizing = false;
                    return;
                }
                if (!PropertyTable.this.getControl().getClientArea().contains(event.x, event.y)) {
                    return;
                }
                EditPart editPart2 = PropertyTable.this.findObjectAt(new Point(event.x, event.y));
                if (editPart2 instanceof PropertyEditPart && PropertyTable.this.isLocationState(propertyInfo = (editPart = (PropertyEditPart)editPart2).getModel(), event.x)) {
                    try {
                        this.m_lastExpandCollapseTime = System.currentTimeMillis();
                        propertyInfo.flip();
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log(e);
                    }
                }
            }
        }

        public void mouseDoubleClick(MouseEvent event, EditPartViewer viewer) {
            if (System.currentTimeMillis() - this.m_lastExpandCollapseTime > (long)PropertyTable.this.getControl().getDisplay().getDoubleClickTime()) {
                try {
                    if (PropertyTable.this.m_activePropertyInfo != null) {
                        if (PropertyTable.this.m_activePropertyInfo.isComplex()) {
                            PropertyTable.this.m_activePropertyInfo.flip();
                        } else {
                            Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                            property.getEditor().doubleClick(property, PropertyTable.this.getValueRelativeLocation(event.x, event.y));
                        }
                    }
                }
                catch (Throwable e) {
                    PropertyTable.this.handleException(e);
                }
            }
        }

        public void mouseMove(MouseEvent event, EditPartViewer viewer) {
            if (!PropertyTable.this.getControl().getClientArea().contains(event.x, event.y)) {
                return;
            }
            if (PropertyTable.this.findObjectAt(new Point(event.x, event.y)) instanceof PropertyEditPart) {
                if (PropertyTable.this.isLocationSplitter(event.x)) {
                    PropertyTable.this.getControl().setCursor(Cursors.SIZEWE);
                } else {
                    PropertyTable.this.getControl().setCursor(null);
                }
                this.updateTooltip(event);
            } else {
                this.updateTooltipNoProperty();
            }
        }

        public void mouseDrag(MouseEvent event, EditPartViewer viewer) {
            if (this.m_splitterResizing) {
                PropertyTable.this.m_splitter = event.x;
                PropertyTable.this.configureSplitter();
                PropertyTable.this.getControl().redraw();
            }
        }

        private void updateTooltip(MouseEvent event) {
            int x = event.x;
            EditPart editPart = PropertyTable.this.findObjectAt(new Point(x, event.y));
            if (editPart instanceof PropertyEditPart) {
                PropertyEditPart editPart2 = (PropertyEditPart)editPart;
                PropertyInfo propertyInfo = editPart2.getModel();
                Property property = propertyInfo.getProperty();
                int y = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart2).bottom();
                int titleX = PropertyTable.this.getTitleTextX(propertyInfo);
                int titleRight = PropertyTable.this.m_splitter - 2;
                if (titleX <= x && x < titleRight) {
                    this.m_tooltipHelper.update(property, true, false, titleX, titleRight, y, PropertyTable.this.m_rowHeight);
                    return;
                }
                int valueX = PropertyTable.this.m_splitter + 3;
                if (x > valueX) {
                    this.m_tooltipHelper.update(property, false, true, valueX, PropertyTable.this.getControl().getClientArea().width, y, PropertyTable.this.m_rowHeight);
                }
            } else {
                this.updateTooltipNoProperty();
            }
        }

        private void updateTooltipNoProperty() {
            this.m_tooltipHelper.update(null, false, false, 0, 0, 0, 0);
        }

        public void keyDown(KeyEvent e, EditPartViewer viewer) {
            if (PropertyTable.this.m_activePropertyInfo != null) {
                try {
                    Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                    if (PropertyTable.this.m_activePropertyInfo.isComplex()) {
                        if (!(PropertyTable.this.m_activePropertyInfo.isExpanded() || e.character != '+' && e.keyCode != 0x1000004)) {
                            PropertyTable.this.m_activePropertyInfo.expand();
                            return;
                        }
                        if (PropertyTable.this.m_activePropertyInfo.isExpanded() && (e.character == '-' || e.keyCode == 0x1000003)) {
                            PropertyTable.this.m_activePropertyInfo.collapse();
                            return;
                        }
                    }
                    if (this.navigate(e)) {
                        return;
                    }
                    if (e.character == ' ' || e.character == '\r') {
                        PropertyTable.this.activateEditor(property, null);
                        return;
                    }
                    if (e.keyCode == 127) {
                        e.doit = false;
                        property.setValue(Property.UNKNOWN_VALUE);
                        return;
                    }
                    property.getEditor().keyDown(PropertyTable.this, property, e);
                }
                catch (Throwable ex) {
                    DesignerPlugin.log(ex);
                }
            }
        }

        public boolean navigate(KeyEvent e) {
            int index = PropertyTable.this.m_properties.indexOf(PropertyTable.this.m_activePropertyInfo);
            int page = PropertyTable.this.getControl().getClientArea().height / PropertyTable.this.m_rowHeight;
            int newIndex = index;
            if (e.keyCode == 0x1000007) {
                newIndex = 0;
            } else if (e.keyCode == 0x1000008) {
                newIndex = PropertyTable.this.m_properties.size() - 1;
            } else if (e.keyCode == 0x1000005) {
                newIndex = Math.max(index - page + 1, 0);
            } else if (e.keyCode == 0x1000006) {
                newIndex = Math.min(index + page - 1, PropertyTable.this.m_properties.size() - 1);
            } else if (e.keyCode == 0x1000001) {
                newIndex = Math.max(index - 1, 0);
            } else if (e.keyCode == 0x1000002) {
                newIndex = Math.min(index + 1, PropertyTable.this.m_properties.size() - 1);
            }
            if (newIndex != index && newIndex < PropertyTable.this.m_properties.size()) {
                PropertyTable.this.setActivePropertyInfo(PropertyTable.this.m_properties.get(newIndex));
                return true;
            }
            return false;
        }
    }

    private final class PropertyEditPart
    extends AbstractGraphicalEditPart {
        private PropertyFigure propertyFigure;

        public PropertyEditPart(PropertyInfo propertyInfo) {
            this.setModel(propertyInfo);
            PropertyTable.this.addSelectionChangedListener(event -> this.refreshVisuals());
        }

        public PropertyInfo getModel() {
            return (PropertyInfo)super.getModel();
        }

        protected IFigure createFigure() {
            SeparatorBorder border = new SeparatorBorder(new Insets(0, 0, 1, 1), 32);
            border.setColor(COLOR_LINE);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.figure = new Figure(){

                public void setParent(IFigure parent) {
                    super.setParent(parent);
                    if (parent != null) {
                        parent.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, false));
                    }
                }
            };
            this.figure.setLayoutManager((LayoutManager)gridLayout);
            this.figure.setBorder((Border)border);
            this.propertyFigure = new PropertyFigure(this.getModel());
            this.propertyFigure.setPreferredSize(new Dimension(-1, PropertyTable.this.m_rowHeight));
            this.propertyFigure.setOpaque(true);
            this.figure.add((IFigure)this.propertyFigure, (Object)new GridData(4, 4, true, false));
            if (this.getModel().getProperty().getEditor().getPresentation() != null) {
                ++gridLayout.numColumns;
                this.figure.add((IFigure)new PresentationFigure(this.getModel()));
            }
            return this.figure;
        }

        protected void createEditPolicies() {
        }

        protected void refreshVisuals() {
            if (this.propertyFigure.isActiveProperty()) {
                this.propertyFigure.setBackgroundColor(COLOR_PROPERTY_BG_SELECTED);
            } else {
                Property property = this.getModel().getProperty();
                try {
                    if (property.isModified()) {
                        this.propertyFigure.setBackgroundColor(COLOR_PROPERTY_BG_MODIFIED);
                    } else {
                        this.propertyFigure.setBackgroundColor(COLOR_PROPERTY_BG);
                    }
                }
                catch (Exception e) {
                    DesignerPlugin.log(e);
                }
            }
        }
    }

    public class PropertyEditPartFactory
    implements EditPartFactory {
        public EditPart createEditPart(EditPart context, Object model) {
            if (model instanceof List) {
                List properties = (List)model;
                if (properties.isEmpty()) {
                    return new NoPropertyEditPart();
                }
                return new PropertyRootEditPart((List)model);
            }
            return new PropertyEditPart((PropertyInfo)model);
        }
    }

    private final class PropertyFigure
    extends Figure {
        private final PropertyInfo m_propertyInfo;

        public PropertyFigure(PropertyInfo propertyInfo) {
            this.m_propertyInfo = propertyInfo;
        }

        protected void paintClientArea(Graphics graphics) {
            int height = this.bounds.height();
            int y = this.bounds.y();
            try {
                Property property = this.m_propertyInfo.getProperty();
                if (this.isActiveProperty()) {
                    PropertyTable.this.setActiveEditorBounds();
                }
                if (this.m_propertyInfo.isShowComplex()) {
                    Image stateImage = this.m_propertyInfo.isExpanded() ? m_minusImage : m_plusImage;
                    DrawUtils.drawImageCV(graphics, stateImage, PropertyTable.this.getTitleX(this.m_propertyInfo), y, height);
                }
                graphics.setForegroundColor(COLOR_PROPERTY_FG_TITLE);
                if (PropertyTable.this.getCategory(property).isAdvanced()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_ADVANCED);
                    graphics.setFont(PropertyTable.this.m_italicFont);
                } else if (PropertyTable.this.getCategory(property).isPreferred() || PropertyTable.this.getCategory(property).isSystem()) {
                    graphics.setFont(PropertyTable.this.m_boldFont);
                }
                if (this.isActiveProperty()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_SELECTED);
                }
                int x = PropertyTable.this.getTitleTextX(this.m_propertyInfo);
                DrawUtils.drawStringCV(graphics, property.getTitle(), x, y, PropertyTable.this.m_splitter - x, height);
                graphics.setFont(PropertyTable.this.m_baseFont);
                if (!this.isActiveProperty()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_VALUE);
                }
                x = PropertyTable.this.m_splitter + 4;
                int w = PropertyTable.this.getControl().getClientArea().width - x - 1;
                property.getEditor().paint(property, graphics, x, y, w, height);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }

        public boolean isActiveProperty() {
            Property property = this.m_propertyInfo.getProperty();
            return PropertyTable.this.m_activePropertyInfo != null && PropertyTable.this.m_activePropertyInfo.getProperty() == property;
        }
    }

    private final class PropertyInfo {
        private final String m_id;
        private final int m_level;
        private final Property m_property;
        private final boolean m_stateComplex;
        private boolean m_stateExpanded;
        private List<PropertyInfo> m_children;

        public PropertyInfo(Property property) {
            this(property, "", 0);
        }

        private PropertyInfo(Property property, String idPrefix, int level) {
            this.m_id = idPrefix + "|" + property.getTitle();
            this.m_level = level;
            this.m_property = property;
            this.m_stateComplex = property.getEditor() instanceof IComplexPropertyEditor;
        }

        public boolean isComplex() {
            return this.m_stateComplex;
        }

        public boolean isShowComplex() throws Exception {
            if (this.m_stateComplex) {
                this.prepareChildren();
                return !CollectionUtils.isEmpty(this.m_children);
            }
            return false;
        }

        public boolean isExpanded() {
            return this.m_stateExpanded;
        }

        public int getLevel() {
            return this.m_level;
        }

        public Property getProperty() {
            return this.m_property;
        }

        public void flip() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            if (this.m_stateExpanded) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void expand() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(!this.m_stateExpanded);
            this.m_stateExpanded = true;
            PropertyTable.this.m_expandedIds.add(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.addChildren(index + 1);
            PropertyTable.this.setContents(PropertyTable.this.m_properties);
        }

        public void collapse() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(this.m_stateExpanded);
            this.m_stateExpanded = false;
            PropertyTable.this.m_expandedIds.remove(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.removeChildren(index + 1);
            PropertyTable.this.setContents(PropertyTable.this.m_properties);
        }

        private int addChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyTable.this.m_properties.add(index++, child);
                if (!child.isExpanded()) continue;
                index = child.addChildren(index);
            }
            return index;
        }

        private void removeChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyEditorPresentation presentation = child.getProperty().getEditor().getPresentation();
                if (presentation != null) {
                    presentation.hide(PropertyTable.this, child.getProperty());
                }
                PropertyTable.this.m_properties.remove(index);
                if (!child.isExpanded()) continue;
                child.removeChildren(index);
            }
        }

        private void prepareChildren() throws Exception {
            if (this.m_children == null) {
                this.m_children = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.getSubProperties();
                int n = propertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Property subProperty = propertyArray[n2];
                    PropertyInfo subPropertyInfo = this.createSubPropertyInfo(subProperty);
                    this.m_children.add(subPropertyInfo);
                    ++n2;
                }
            }
        }

        private PropertyInfo createSubPropertyInfo(Property subProperty) {
            return new PropertyInfo(subProperty, this.m_id, this.m_level + 1);
        }

        private Property[] getSubProperties() throws Exception {
            IComplexPropertyEditor complexEditor = (IComplexPropertyEditor)((Object)this.m_property.getEditor());
            ArrayList<Property> subProperties = new ArrayList<Property>();
            Property[] propertyArray = complexEditor.getProperties(this.m_property);
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property subProperty = propertyArray[n2];
                if (!PropertyTable.this.getCategory(subProperty).isHidden() || subProperty.isModified()) {
                    subProperties.add(subProperty);
                }
                ++n2;
            }
            return subProperties.toArray(new Property[subProperties.size()]);
        }

        public boolean expandFromHistory() throws Exception {
            if (this.isComplex() && !this.isExpanded() && PropertyTable.this.m_expandedIds.contains(this.m_id)) {
                this.expand();
                return true;
            }
            return false;
        }
    }

    private final class PropertyRootEditPart
    extends AbstractGraphicalEditPart {
        public PropertyRootEditPart(List<PropertyInfo> model) {
            this.setModel(model);
        }

        protected IFigure createFigure() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            LineBorder border = new LineBorder(COLOR_LINE){

                public void paint(IFigure f, Graphics g, Insets i) {
                    super.paint(f, g, i);
                    tempRect = 1.getPaintRectangle((IFigure)f, (Insets)i);
                    this.drawExpandLines(g, tempRect);
                    tempRect = 1.getPaintRectangle((IFigure)f, (Insets)i);
                    g.drawLine(((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_splitter, 0, ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_splitter, 1.tempRect.height);
                }

                private void drawExpandLines(Graphics graphics, Rectangle clientArea) {
                    int height = ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_rowHeight - 1;
                    int xOffset = PropertyTable.m_plusImage.getBounds().width / 2;
                    int yOffset = (height - PropertyTable.m_plusImage.getBounds().width) / 2;
                    graphics.setForegroundColor(COLOR_COMPLEX_LINE);
                    int i = 0;
                    while (i < ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.size()) {
                        PropertyInfo propertyInfo = ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.get(i);
                        if (propertyInfo.isExpanded()) {
                            PropertyInfo nextPropertyInfo;
                            int index;
                            int index2 = index = ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.indexOf(propertyInfo);
                            while (index2 < ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.size()) {
                                nextPropertyInfo = ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.get(index2);
                                if (nextPropertyInfo != propertyInfo && nextPropertyInfo.getLevel() <= propertyInfo.getLevel()) break;
                                ++index2;
                            }
                            if (--index2 > index) {
                                nextPropertyInfo = ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_properties.get(index2);
                                GraphicalEditPart editPart = (GraphicalEditPart)PropertyTable.this.getEditPartRegistry().get(propertyInfo);
                                GraphicalEditPart nextEditPart = (GraphicalEditPart)PropertyTable.this.getEditPartRegistry().get(nextPropertyInfo);
                                if (editPart != null && nextEditPart != null) {
                                    Rectangle bounds = editPart.getFigure().getBounds();
                                    Rectangle nextBounds = nextEditPart.getFigure().getBounds();
                                    int x = PropertyTable.this.getTitleX(propertyInfo) + xOffset;
                                    int y1 = bounds.top() + height - yOffset;
                                    int y2 = nextBounds.top() + ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_rowHeight / 2;
                                    graphics.drawLine(x, y1, x, y2);
                                    graphics.drawLine(x, y2, x + ((PropertyRootEditPart)PropertyRootEditPart.this).PropertyTable.this.m_rowHeight / 3, y2);
                                }
                            }
                        }
                        ++i;
                    }
                }
            };
            this.figure = new Figure();
            this.figure.setBorder((Border)border);
            this.figure.setBackgroundColor(COLOR_BACKGROUND);
            this.figure.setLayoutManager((LayoutManager)gridLayout);
            this.figure.setOpaque(true);
            return this.figure;
        }

        protected void createEditPolicies() {
        }

        public List<PropertyInfo> getModel() {
            return (List)super.getModel();
        }

        protected List<PropertyInfo> getModelChildren() {
            Object model = this.getModel();
            if (model == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(model);
        }
    }
}

