/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.ui.preferences.ProcessStreamConnectionProviderWithPreference;
import org.eclipse.wildwebdeveloper.yaml.ui.preferences.YAMLPreferenceServerConstants;

public class YAMLLanguageServer
extends ProcessStreamConnectionProviderWithPreference {
    private static final String YAML_LANGUAGE_SERVER_ID = "org.eclipse.wildwebdeveloper.yaml";
    private static final String[] SUPPORTED_SECTIONS = new String[]{"yaml"};

    public YAMLLanguageServer() {
        super(YAML_LANGUAGE_SERVER_ID, Activator.getDefault().getPreferenceStore(), SUPPORTED_SECTIONS);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/yaml-language-server/out/server/src/server.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        ResponseMessage responseMessage;
        if (message instanceof ResponseMessage && (responseMessage = (ResponseMessage)message).getResult() instanceof InitializeResult) {
            Object settings = this.createSettings();
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }

    @Override
    protected boolean isAffected(PropertyChangeEvent event) {
        return super.isAffected(event) || "wildwebdeveloper.yaml.schema".equals(event.getProperty());
    }

    @Override
    protected Object createSettings() {
        return YAMLPreferenceServerConstants.getGlobalSettings();
    }

    public String toString() {
        return "YAML Language Server: " + super.toString();
    }
}

