/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class UnsafeWrapper
implements Supplier<Object> {
    protected ThrowExceptionFunction throwExceptionFunction;
    protected static Object unsafe;
    protected static Class<?> unsafeClass;
    protected static MethodHandle allocateInstance;
    protected static MethodHandle objectFieldOffset;
    protected static MethodHandle staticFieldOffset;
    protected static MethodHandle getObject;
    protected static MethodHandle getObjectVolatile;
    protected static MethodHandle getShort;
    protected static MethodHandle getShortVolatile;
    protected static MethodHandle getInt;
    protected static MethodHandle getIntVolatile;
    protected static MethodHandle getLong;
    protected static MethodHandle getLongVolatile;
    protected static MethodHandle getFloat;
    protected static MethodHandle getFloatVolatile;
    protected static MethodHandle getDouble;
    protected static MethodHandle getDoubleVolatile;
    protected static MethodHandle getBoolean;
    protected static MethodHandle getBooleanVolatile;
    protected static MethodHandle getByte;
    protected static MethodHandle getByteVolatile;
    protected static MethodHandle getChar;
    protected static MethodHandle getCharVolatile;
    protected static MethodHandle putObject;
    protected static MethodHandle putObjectVolatile;
    protected static MethodHandle putShort;
    protected static MethodHandle putShortVolatile;
    protected static MethodHandle putInt;
    protected static MethodHandle putIntVolatile;
    protected static MethodHandle putLong;
    protected static MethodHandle putLongVolatile;
    protected static MethodHandle putFloat;
    protected static MethodHandle putFloatVolatile;
    protected static MethodHandle putDouble;
    protected static MethodHandle putDoubleVolatile;
    protected static MethodHandle putBoolean;
    protected static MethodHandle putBooleanVolatile;
    protected static MethodHandle putByte;
    protected static MethodHandle putByteVolatile;
    protected static MethodHandle putChar;
    protected static MethodHandle putCharVolatile;

    protected synchronized boolean init(Map<Object, Object> context, String unsafeClassName) throws Throwable {
        this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
        if (unsafeClass != null && unsafeClass.getName().equals(unsafeClassName)) {
            return false;
        }
        Field unsafeField = Class.forName(unsafeClassName).getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        this.init(unsafeField.get(null), MethodHandles.lookup());
        return true;
    }

    protected void init(Object unsafeObject, MethodHandles.Lookup lookup) throws NoSuchMethodException, IllegalAccessException {
        allocateInstance = lookup.bind(unsafeObject, "allocateInstance", MethodType.methodType(Object.class, Class.class));
        objectFieldOffset = lookup.bind(unsafeObject, "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
        staticFieldOffset = lookup.bind(unsafeObject, "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
        getObject = lookup.bind(unsafeObject, "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
        getObjectVolatile = lookup.bind(unsafeObject, "getObjectVolatile", MethodType.methodType(Object.class, Object.class, Long.TYPE));
        getShort = lookup.bind(unsafeObject, "getShort", MethodType.methodType(Short.TYPE, Object.class, Long.TYPE));
        getShortVolatile = lookup.bind(unsafeObject, "getShortVolatile", MethodType.methodType(Short.TYPE, Object.class, Long.TYPE));
        getInt = lookup.bind(unsafeObject, "getInt", MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE));
        getIntVolatile = lookup.bind(unsafeObject, "getIntVolatile", MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE));
        getLong = lookup.bind(unsafeObject, "getLong", MethodType.methodType(Long.TYPE, Object.class, Long.TYPE));
        getLongVolatile = lookup.bind(unsafeObject, "getLongVolatile", MethodType.methodType(Long.TYPE, Object.class, Long.TYPE));
        getFloat = lookup.bind(unsafeObject, "getFloat", MethodType.methodType(Float.TYPE, Object.class, Long.TYPE));
        getFloatVolatile = lookup.bind(unsafeObject, "getFloatVolatile", MethodType.methodType(Float.TYPE, Object.class, Long.TYPE));
        getDouble = lookup.bind(unsafeObject, "getDouble", MethodType.methodType(Double.TYPE, Object.class, Long.TYPE));
        getDoubleVolatile = lookup.bind(unsafeObject, "getDoubleVolatile", MethodType.methodType(Double.TYPE, Object.class, Long.TYPE));
        getBoolean = lookup.bind(unsafeObject, "getBoolean", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE));
        getBooleanVolatile = lookup.bind(unsafeObject, "getBooleanVolatile", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE));
        getByte = lookup.bind(unsafeObject, "getByte", MethodType.methodType(Byte.TYPE, Object.class, Long.TYPE));
        getByteVolatile = lookup.bind(unsafeObject, "getByteVolatile", MethodType.methodType(Byte.TYPE, Object.class, Long.TYPE));
        getChar = lookup.bind(unsafeObject, "getChar", MethodType.methodType(Character.TYPE, Object.class, Long.TYPE));
        getCharVolatile = lookup.bind(unsafeObject, "getCharVolatile", MethodType.methodType(Character.TYPE, Object.class, Long.TYPE));
        putObject = lookup.bind(unsafeObject, "putObject", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class));
        putObjectVolatile = lookup.bind(unsafeObject, "putObjectVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class));
        putShort = lookup.bind(unsafeObject, "putShort", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Short.TYPE));
        putShortVolatile = lookup.bind(unsafeObject, "putShortVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Short.TYPE));
        putInt = lookup.bind(unsafeObject, "putInt", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Integer.TYPE));
        putIntVolatile = lookup.bind(unsafeObject, "putIntVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Integer.TYPE));
        putLong = lookup.bind(unsafeObject, "putLong", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Long.TYPE));
        putLongVolatile = lookup.bind(unsafeObject, "putLongVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Long.TYPE));
        putFloat = lookup.bind(unsafeObject, "putFloat", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Float.TYPE));
        putFloatVolatile = lookup.bind(unsafeObject, "putFloatVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Float.TYPE));
        putDouble = lookup.bind(unsafeObject, "putDouble", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Double.TYPE));
        putDoubleVolatile = lookup.bind(unsafeObject, "putDoubleVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Double.TYPE));
        putBoolean = lookup.bind(unsafeObject, "putBoolean", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Boolean.TYPE));
        putBooleanVolatile = lookup.bind(unsafeObject, "putBooleanVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Boolean.TYPE));
        putByte = lookup.bind(unsafeObject, "putByte", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Byte.TYPE));
        putByteVolatile = lookup.bind(unsafeObject, "putByteVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Byte.TYPE));
        putChar = lookup.bind(unsafeObject, "putChar", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Character.TYPE));
        putCharVolatile = lookup.bind(unsafeObject, "putCharVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Character.TYPE));
        unsafe = unsafeObject;
        unsafeClass = unsafeObject.getClass();
    }

    @Override
    public Object get() {
        return unsafe;
    }

    public Class<?> getUnsafeClass() {
        return unsafeClass;
    }

    public Object allocateInstance(Class<?> cls) {
        return this.invokeAndReturn(allocateInstance, cls);
    }

    public long objectFieldOffset(Field field) {
        return (Long)this.invokeAndReturn(objectFieldOffset, field);
    }

    public long staticFieldOffset(Field field) {
        return (Long)this.invokeAndReturn(staticFieldOffset, field);
    }

    public Object getObject(Object target, long fieldOffset) {
        return this.invokeAndReturn(getObject, target, fieldOffset);
    }

    public Object getObjectVolatile(Object target, long fieldOffset) {
        return this.invokeAndReturn(getObjectVolatile, fieldOffset);
    }

    public short getShort(Object target, long fieldOffset) {
        return (Short)this.invokeAndReturn(getShort, fieldOffset);
    }

    public short getShortVolatile(Object target, long fieldOffset) {
        return (Short)this.invokeAndReturn(getShortVolatile, fieldOffset);
    }

    public int getInt(Object target, long fieldOffset) {
        return (Integer)this.invokeAndReturn(getInt, fieldOffset);
    }

    public int getIntVolatile(Object target, long fieldOffset) {
        return (Integer)this.invokeAndReturn(getIntVolatile, fieldOffset);
    }

    public long getLong(Object target, long fieldOffset) {
        return (Long)this.invokeAndReturn(getLong, fieldOffset);
    }

    public long getLongVolatile(Object target, long fieldOffset) {
        return (Long)this.invokeAndReturn(getLongVolatile, fieldOffset);
    }

    public float getFloat(Object target, long fieldOffset) {
        return ((Float)this.invokeAndReturn(getFloat, fieldOffset)).floatValue();
    }

    public float getFloatVolatile(Object target, long fieldOffset) {
        return ((Float)this.invokeAndReturn(getFloatVolatile, fieldOffset)).floatValue();
    }

    public double getDouble(Object target, long fieldOffset) {
        return (Double)this.invokeAndReturn(getDouble, fieldOffset);
    }

    public double getDoubleVolatile(Object target, long fieldOffset) {
        return (Double)this.invokeAndReturn(getDoubleVolatile, fieldOffset);
    }

    public boolean getBoolean(Object target, long fieldOffset) {
        return (Boolean)this.invokeAndReturn(getBoolean, fieldOffset);
    }

    public boolean getBooleanVolatile(Object target, long fieldOffset) {
        return (Boolean)this.invokeAndReturn(getBooleanVolatile, fieldOffset);
    }

    public byte getByte(Object target, long fieldOffset) {
        return (Byte)this.invokeAndReturn(getByte, fieldOffset);
    }

    public byte getByteVolatile(Object target, long fieldOffset) {
        return (Byte)this.invokeAndReturn(getByteVolatile, fieldOffset);
    }

    public char getChar(Object target, long fieldOffset) {
        return ((Character)this.invokeAndReturn(getChar, fieldOffset)).charValue();
    }

    public char getCharVolatile(Object target, long fieldOffset) {
        return ((Character)this.invokeAndReturn(getCharVolatile, fieldOffset)).charValue();
    }

    public void putObject(Object target, long fieldOffset, Object value) {
        this.invoke(putObject, fieldOffset, value);
    }

    public void putObjectVolatile(Object target, long fieldOffset, Object value) {
        this.invoke(putObjectVolatile, fieldOffset, value);
    }

    public void putShort(Object target, long fieldOffset, short value) {
        this.invoke(putShort, fieldOffset, value);
    }

    public void putShortVolatile(Object target, long fieldOffset, short value) {
        this.invoke(putShortVolatile, fieldOffset, value);
    }

    public void putInt(Object target, long fieldOffset, int value) {
        this.invoke(putInt, fieldOffset, value);
    }

    public void putIntVolatile(Object target, long fieldOffset, int value) {
        this.invoke(putIntVolatile, fieldOffset, value);
    }

    public void putLong(Object target, long fieldOffset, long value) {
        this.invoke(putLong, fieldOffset, value);
    }

    public void putLongVolatile(Object target, long fieldOffset, long value) {
        this.invoke(putLongVolatile, fieldOffset, value);
    }

    public void putFloat(Object target, long fieldOffset, float value) {
        this.invoke(putFloat, fieldOffset, Float.valueOf(value));
    }

    public void putFloatVolatile(Object target, long fieldOffset, float value) {
        this.invoke(putFloatVolatile, fieldOffset, Float.valueOf(value));
    }

    public void putDouble(Object target, long fieldOffset, double value) {
        this.invoke(putDouble, fieldOffset, value);
    }

    public void putDoubleVolatile(Object target, long fieldOffset, double value) {
        this.invoke(putDoubleVolatile, fieldOffset, value);
    }

    public void putBoolean(Object target, long fieldOffset, boolean value) {
        this.invoke(putBoolean, fieldOffset, value);
    }

    public void putBooleanVolatile(Object target, long fieldOffset, boolean value) {
        this.invoke(putBooleanVolatile, fieldOffset, value);
    }

    public void putByte(Object target, long fieldOffset, byte value) {
        this.invoke(putByte, fieldOffset, value);
    }

    public void putByteVolatile(Object target, long fieldOffset, byte value) {
        this.invoke(putByteVolatile, fieldOffset, value);
    }

    public void putChar(Object target, long fieldOffset, char value) {
        this.invoke(putChar, fieldOffset, Character.valueOf(value));
    }

    public void putCharVolatile(Object target, long fieldOffset, char value) {
        this.invoke(putCharVolatile, fieldOffset, Character.valueOf(value));
    }

    private void invoke(MethodHandle method, Object ... parameters) {
        try {
            method.invoke(parameters);
        }
        catch (Throwable exc) {
            this.throwExceptionFunction.accept(exc);
        }
    }

    private Object invokeAndReturn(MethodHandle method, Object ... parameters) {
        try {
            return method.invoke(parameters);
        }
        catch (Throwable exc) {
            return this.throwExceptionFunction.apply(exc);
        }
    }

    public static class ForJava7
    extends UnsafeWrapper {
        private static final String UNSAFE_CLASS_NAME = "sun.misc.Unsafe";

        public ForJava7(Map<Object, Object> context) throws Throwable {
            super.init(context, UNSAFE_CLASS_NAME);
        }
    }
}

