/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.ByteBufferInputStream;
import org.burningwave.core.io.FileOutputStream;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.IterableZipContainer;

public class ZipInputStream
extends java.util.zip.ZipInputStream
implements IterableZipContainer {
    String absolutePath;
    String conventionedAbsolutePath;
    IterableZipContainer parent;
    IterableZipContainer.Entry currentZipEntry;
    ByteBufferInputStream byteBufferInputStream;

    ZipInputStream(String absolutePath, InputStream inputStream) {
        super(inputStream);
        this.absolutePath = absolutePath;
    }

    ZipInputStream(String absolutePath, ByteBufferInputStream inputStream) {
        super(inputStream);
        this.absolutePath = absolutePath;
        this.byteBufferInputStream = inputStream;
    }

    @Override
    public Function<IterableZipContainer.Entry, IterableZipContainer.Entry> getEntrySupplier() {
        return Entry.Detached::new;
    }

    @Override
    public IterableZipContainer getParent() {
        if (this.conventionedAbsolutePath == null) {
            this.getConventionedAbsolutePath();
        }
        return this.parent;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConventionedAbsolutePath() {
        if (this.conventionedAbsolutePath == null) {
            ZipInputStream zipInputStream = this;
            synchronized (zipInputStream) {
                if (this.parent != null) {
                    this.conventionedAbsolutePath = this.parent.getConventionedAbsolutePath() + this.absolutePath.replace(this.parent.getAbsolutePath() + "/", "");
                } else {
                    FileSystemItem zipFis = FileSystemItem.ofPath(this.absolutePath);
                    if (zipFis.getParentContainer().isArchive()) {
                        this.parent = IterableZipContainer.create(zipFis.getParentContainer().getAbsolutePath());
                        return this.getConventionedAbsolutePath();
                    }
                    this.conventionedAbsolutePath = this.absolutePath;
                }
                this.conventionedAbsolutePath = this.conventionedAbsolutePath + "///";
            }
        }
        return this.conventionedAbsolutePath;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.byteBufferInputStream.toByteBuffer();
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.BufferHandler.toByteArray(this.toByteBuffer());
    }

    @Override
    protected Entry.Attached createZipEntry(String name) {
        return new Entry.Attached(name, this);
    }

    @Override
    public Entry.Attached getNextEntry() {
        return (Entry.Attached)this.getNextEntry(zEntry -> false);
    }

    @Override
    public synchronized IterableZipContainer.Entry getNextEntry(Predicate<IterableZipContainer.Entry> loadZipEntryData) {
        Executor.run(() -> {
            try {
                this.currentZipEntry = (Entry.Attached)super.getNextEntry();
            }
            catch (ZipException exc) {
                String message = exc.getMessage();
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not open zipEntry of {}: {}", this.absolutePath, message);
            }
        });
        if (this.currentZipEntry != null && loadZipEntryData.test(this.currentZipEntry)) {
            this.currentZipEntry.toByteBuffer();
        }
        return this.currentZipEntry;
    }

    public synchronized IterableZipContainer.Entry getNextEntryAsDetached() {
        return this.getNextEntryAsDetached(zEntry -> false);
    }

    public IterableZipContainer.Entry getNextEntryAsDetached(Predicate<IterableZipContainer.Entry> loadZipEntryData) {
        return Optional.ofNullable(this.getNextEntry(loadZipEntryData)).map(zipEntry -> ((Entry.Attached)zipEntry).convert()).orElseGet(() -> null);
    }

    @Override
    public IterableZipContainer.Entry getCurrentZipEntry() {
        return this.currentZipEntry;
    }

    public IterableZipContainer.Entry convertCurrentZipEntry() {
        return ((Entry.Attached)this.getCurrentZipEntry()).convert();
    }

    @Override
    public synchronized void closeEntry() {
        if (this.currentZipEntry != null) {
            try {
                super.closeEntry();
            }
            catch (IOException exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Exception occurred while closing zipEntry {}: {}", Optional.ofNullable(this.getCurrentZipEntry()).map(zipEntry -> zipEntry.getAbsolutePath()).orElseGet(() -> "null"), exc.getMessage());
            }
            this.currentZipEntry.close();
            this.currentZipEntry = null;
        }
    }

    @Override
    public void close() {
        this.closeEntry();
        this.parent = null;
        this.absolutePath = null;
        Executor.run(() -> super.close());
        this.byteBufferInputStream = null;
    }

    public static interface Entry
    extends IterableZipContainer.Entry {

        public static class Detached
        implements Entry {
            private String name;
            private String cleanedName;
            private String absolutePath;
            private IterableZipContainer zipInputStream;
            private Boolean archive;

            Detached(IterableZipContainer.Entry zipEntry) {
                this.name = zipEntry.getName();
                this.absolutePath = zipEntry.getAbsolutePath();
                this.zipInputStream = zipEntry.getParentContainer().duplicate();
            }

            @Override
            public boolean isArchive() {
                if (this.archive != null) {
                    return this.archive;
                }
                ByteBuffer content = this.toByteBuffer();
                this.archive = content != null ? StaticComponentContainer.Streams.isArchive(content) : false;
                return this.archive;
            }

            @Override
            public IterableZipContainer getParentContainer() {
                return this.zipInputStream.duplicate();
            }

            @Override
            public ByteBuffer toByteBuffer() {
                return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(this.absolutePath, () -> {
                    try (IterableZipContainer zipInputStream = this.getParentContainer();){
                        ByteBuffer byteBuffer = zipInputStream.findFirstAndConvert(entry -> entry.getName().equals(this.getName()), zEntry -> zEntry.toByteBuffer(), zEntry -> true);
                        return byteBuffer;
                    }
                });
            }

            @Override
            public String getCleanedName() {
                if (this.cleanedName != null) {
                    return this.cleanedName;
                }
                String cleanedName = this.name;
                this.cleanedName = !cleanedName.startsWith("/") ? cleanedName : (!cleanedName.equals("/") ? cleanedName.substring(1, cleanedName.length()) : "");
                return this.cleanedName;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getAbsolutePath() {
                return this.absolutePath;
            }

            @Override
            public boolean isDirectory() {
                return this.name.endsWith("/");
            }

            @Override
            public void close() {
                this.name = null;
                this.archive = null;
                this.cleanedName = null;
                this.absolutePath = null;
                this.zipInputStream.close();
                this.zipInputStream = null;
            }
        }

        public static class Attached
        extends ZipEntry
        implements Entry {
            private ZipInputStream zipInputStream;
            private String absolutePath;
            private String cleanedName;
            private Boolean archive;

            Attached(Attached e, ZipInputStream zIS) {
                super(e);
                this.zipInputStream = zIS;
            }

            Attached(String name, ZipInputStream zIS) {
                super(name);
                this.zipInputStream = zIS;
            }

            @Override
            public boolean isArchive() {
                if (this.archive != null) {
                    return this.archive;
                }
                ByteBuffer content = this.toByteBuffer();
                this.archive = content != null ? StaticComponentContainer.Streams.isArchive(content) : false;
                return this.archive;
            }

            @Override
            public IterableZipContainer getParentContainer() {
                return this.zipInputStream;
            }

            @Override
            public String getCleanedName() {
                if (this.cleanedName != null) {
                    return this.cleanedName;
                }
                String cleanedName = super.getName();
                this.cleanedName = !cleanedName.startsWith("/") ? cleanedName : (!cleanedName.equals("/") ? cleanedName.substring(1, cleanedName.length()) : "");
                return this.cleanedName;
            }

            @Override
            public String getAbsolutePath() {
                if (this.absolutePath != null) {
                    return this.absolutePath;
                }
                this.absolutePath = StaticComponentContainer.Paths.clean(this.zipInputStream.getAbsolutePath() + "/" + this.getName());
                return this.absolutePath;
            }

            @Override
            public long getSize() {
                long size = super.getSize();
                if (size < 0L) {
                    size = StaticComponentContainer.BufferHandler.limit(this.toByteBuffer());
                }
                return size;
            }

            private ByteBuffer loadContent() {
                return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(this.getAbsolutePath(), () -> {
                    if (this.zipInputStream.getCurrentZipEntry() != this) {
                        StaticComponentContainer.Driver.throwException("{} and his ZipInputStream are not aligned", new Object[]{Attached.class.getSimpleName()});
                    }
                    try {
                        return StaticComponentContainer.Streams.toByteBuffer(this.zipInputStream, (int)super.getSize());
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Could not load content of {} of {}", exc, this.getName(), this.zipInputStream.getAbsolutePath());
                        return null;
                    }
                });
            }

            @Override
            public ByteBuffer toByteBuffer() {
                return this.loadContent();
            }

            public IterableZipContainer.Entry convert() {
                return new Detached(this);
            }

            public void unzipToFolder(File folder) {
                File destinationFilePath = new File(folder.getAbsolutePath(), this.getName());
                int defaultBufferSize = StaticComponentContainer.BufferHandler.getDefaultBufferSize();
                destinationFilePath.getParentFile().mkdirs();
                if (!this.isDirectory()) {
                    Executor.run(() -> {
                        try (BufferedInputStream bis = new BufferedInputStream(this.toInputStream());){
                            int byteTransferred = 0;
                            byte[] buffer = new byte[defaultBufferSize];
                            try (FileOutputStream fos = FileOutputStream.create(destinationFilePath);
                                 BufferedOutputStream bos = new BufferedOutputStream(fos, defaultBufferSize);){
                                while ((byteTransferred = bis.read(buffer, 0, defaultBufferSize)) != -1) {
                                    bos.write(buffer, 0, byteTransferred);
                                }
                                bos.flush();
                            }
                        }
                    });
                }
            }

            @Override
            public void close() {
                this.zipInputStream = null;
                this.absolutePath = null;
                this.cleanedName = null;
                this.archive = null;
            }
        }
    }
}

