/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.service.command.events.MITracepointSelectedEvent;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl2;
import org.eclipse.cdt.dsf.gdb.service.Messages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLITraceDumpInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITraceFindInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITraceListVariablesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITraceStatusInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITraceStopInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GDBTraceControl_7_2
extends AbstractDsfService
implements IGDBTraceControl2,
ICachingService {
    private CommandCache fTraceStatusCache;
    private ICommandControlService fConnection;
    private CommandFactory fCommandFactory;
    private IGDBBackend fBackend;
    private IGDBTraceControl.ITraceRecordDMContext fCurrentRecordDmc;
    private int fTracepointIndexForTraceRecord;
    private boolean fIsTracingActive;
    private boolean fIsTracingCurrentlySupported;
    private boolean fIsTracingFeatureAvailable = true;
    private int fTraceRecordsStored;

    public GDBTraceControl_7_2(DsfSession session, ILaunchConfiguration config) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBTraceControl_7_2.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{IGDBTraceControl.class.getName(), IGDBTraceControl2.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fTraceStatusCache = new CommandCache(this.getSession(), (ICommandControl)this.fConnection);
        this.fTraceStatusCache.setContextAvailable((IDMContext)this.fConnection.getContext(), true);
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected boolean isTracingCurrentlySupported() {
        return this.fIsTracingCurrentlySupported;
    }

    protected CommandCache getTraceStatusCache() {
        return this.fTraceStatusCache;
    }

    @Override
    public void canStartTracing(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (this.fCurrentRecordDmc != null) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)true);
        rm.done();
    }

    @Override
    public void startTracing(final IGDBTraceControl.ITraceTargetDMContext context, final RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        this.canStartTracing(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!((Boolean)this.getData()).booleanValue()) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot start tracing", null));
                    rm.done();
                    return;
                }
                GDBTraceControl_7_2.this.fConnection.queueCommand(GDBTraceControl_7_2.this.fCommandFactory.createMITraceStart(context), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBTraceControl_7_2.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        (this).GDBTraceControl_7_2.this.fTraceStatusCache.reset((IDMContext)context);
                        (this).GDBTraceControl_7_2.this.fIsTracingActive = true;
                        GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TracingStartedEvent(context), GDBTraceControl_7_2.this.getProperties());
                        rm.done();
                    }

                    protected void handleError() {
                        AbstractDMEvent event = (this).GDBTraceControl_7_2.this.fIsTracingActive ? new TracingStartedEvent(context) : new TracingStoppedEvent(context);
                        GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)event, GDBTraceControl_7_2.this.getProperties());
                        rm.done();
                    }
                });
            }
        });
    }

    @Override
    public void canStopTracing(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (this.fCurrentRecordDmc != null) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        this.isTracing(context, rm);
    }

    @Override
    public void stopTracing(final IGDBTraceControl.ITraceTargetDMContext context, final RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        this.canStopTracing(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!((Boolean)this.getData()).booleanValue()) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot stop tracing", null));
                    rm.done();
                    return;
                }
                GDBTraceControl_7_2.this.fConnection.queueCommand(GDBTraceControl_7_2.this.fCommandFactory.createMITraceStop(context), (DataRequestMonitor)new DataRequestMonitor<MITraceStopInfo>((Executor)GDBTraceControl_7_2.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        (this).GDBTraceControl_7_2.this.fTraceStatusCache.reset((IDMContext)context);
                        MITraceStopInfo info = (MITraceStopInfo)this.getData();
                        if ((this).GDBTraceControl_7_2.this.fIsTracingActive != info.isTracingActive()) {
                            (this).GDBTraceControl_7_2.this.fIsTracingActive = info.isTracingActive();
                            if (!(this).GDBTraceControl_7_2.this.fIsTracingActive) {
                                GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TracingStoppedEvent(context), GDBTraceControl_7_2.this.getProperties());
                            }
                        }
                        (this).GDBTraceControl_7_2.this.fTraceRecordsStored = info.getNumberOfCollectedFrame();
                        rm.done();
                    }
                });
            }
        });
    }

    @Override
    public void isTracing(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)this.fIsTracingActive);
        rm.done();
    }

    @Override
    public void canSaveTraceData(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)(this.fTraceRecordsStored > 0 ? 1 : 0));
        rm.done();
    }

    @Override
    public void saveTraceData(final IGDBTraceControl.ITraceTargetDMContext context, final String file, final boolean remoteSave, final RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        this.canSaveTraceData(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!((Boolean)this.getData()).booleanValue()) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot save trace data", null));
                    rm.done();
                    return;
                }
                GDBTraceControl_7_2.this.fConnection.queueCommand(GDBTraceControl_7_2.this.fCommandFactory.createMITraceSave(context, file, remoteSave), new DataRequestMonitor((Executor)GDBTraceControl_7_2.this.getExecutor(), rm));
            }
        });
    }

    @Override
    public void canLoadTraceData(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        rm.setData((Object)true);
        rm.done();
    }

    @Override
    public void loadTraceData(final IGDBTraceControl.ITraceTargetDMContext context, final String file, final RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        this.canLoadTraceData(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!((Boolean)this.getData()).booleanValue()) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot load trace data", null));
                    rm.done();
                    return;
                }
                GDBTraceControl_7_2.this.fConnection.queueCommand(GDBTraceControl_7_2.this.fCommandFactory.createMITargetSelectTFile(context, file), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)GDBTraceControl_7_2.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        (this).GDBTraceControl_7_2.this.fTraceStatusCache.reset((IDMContext)context);
                        (this).GDBTraceControl_7_2.this.fIsTracingCurrentlySupported = true;
                        final IGDBTraceControl.ITraceRecordDMContext initialRecord = GDBTraceControl_7_2.this.createTraceRecordContext(context, "0");
                        GDBTraceControl_7_2.this.selectTraceRecord(initialRecord, (RequestMonitor)new ImmediateRequestMonitor(rm){

                            protected void handleSuccess() {
                                GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TraceRecordSelectedChangedEvent(initialRecord), GDBTraceControl_7_2.this.getProperties());
                                rm.done();
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public void getTraceStatus(final IGDBTraceControl.ITraceTargetDMContext context, final DataRequestMonitor<IGDBTraceControl.ITraceStatusDMData> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingFeatureAvailable) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        this.getExecutor().schedule(() -> this.fTraceStatusCache.reset((IDMContext)context), 300L, TimeUnit.MILLISECONDS);
        this.fTraceStatusCache.execute(this.fCommandFactory.createMITraceStatus(context), (DataRequestMonitor)new DataRequestMonitor<MITraceStatusInfo>((Executor)this.getExecutor(), rm){

            protected void handleError() {
                GDBTraceControl_7_2.this.fIsTracingFeatureAvailable = false;
                super.handleError();
            }

            protected void handleSuccess() {
                MITraceStatusInfo info = (MITraceStatusInfo)this.getData();
                if (GDBTraceControl_7_2.this.fIsTracingCurrentlySupported != info.isTracingSupported()) {
                    GDBTraceControl_7_2.this.fIsTracingCurrentlySupported = info.isTracingSupported();
                    GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TracingSupportedChangeEvent(context, GDBTraceControl_7_2.this.fIsTracingCurrentlySupported), GDBTraceControl_7_2.this.getProperties());
                }
                if (GDBTraceControl_7_2.this.fIsTracingCurrentlySupported) {
                    if (GDBTraceControl_7_2.this.fIsTracingActive != info.isTracingActive()) {
                        GDBTraceControl_7_2.this.fIsTracingActive = info.isTracingActive();
                        if (GDBTraceControl_7_2.this.fIsTracingActive) {
                            GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TracingStartedEvent(context), GDBTraceControl_7_2.this.getProperties());
                        } else {
                            GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TracingStoppedEvent(context), GDBTraceControl_7_2.this.getProperties());
                        }
                    }
                    GDBTraceControl_7_2.this.fTraceRecordsStored = info.getNumberOfCollectedFrame();
                    rm.setData((Object)new TraceStatusDMData(info));
                } else {
                    GDBTraceControl_7_2.this.fTraceRecordsStored = 0;
                    GDBTraceControl_7_2.this.fIsTracingActive = false;
                    rm.setData((Object)new TraceStatusDMData());
                }
                rm.done();
            }
        });
    }

    @Override
    public void createTraceVariable(IGDBTraceControl.ITraceTargetDMContext context, String varName, String varValue, RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (varValue == null) {
            this.fConnection.queueCommand(this.fCommandFactory.createMITraceDefineVariable(context, varName), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            this.fConnection.queueCommand(this.fCommandFactory.createMITraceDefineVariable(context, varName, varValue), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        }
    }

    @Override
    public void getTraceVariables(IGDBTraceControl.ITraceTargetDMContext context, final DataRequestMonitor<IGDBTraceControl.ITraceVariableDMData[]> rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMITraceListVariables(context), (DataRequestMonitor)new DataRequestMonitor<MITraceListVariablesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MITraceListVariablesInfo.MITraceVariableInfo[] vars = ((MITraceListVariablesInfo)this.getData()).getTraceVariables();
                TraceVariableDMData[] varDataArray = new TraceVariableDMData[vars.length];
                int i = 0;
                while (i < vars.length) {
                    varDataArray[i] = new TraceVariableDMData(vars[i].getName(), vars[i].getInitialValue(), vars[i].getCurrentValue());
                    ++i;
                }
                rm.setData((Object)varDataArray);
                rm.done();
            }
        });
    }

    @Override
    public IGDBTraceControl.ITraceRecordDMContext createTraceRecordContext(IGDBTraceControl.ITraceTargetDMContext ctx, String recordId) {
        return new MITraceRecordDMContext(this.getSession(), ctx, recordId);
    }

    @Override
    public IGDBTraceControl.ITraceRecordDMContext createNextRecordContext(IGDBTraceControl.ITraceRecordDMContext ctx) {
        IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IGDBTraceControl.ITraceTargetDMContext.class);
        if (ctx instanceof InvalidTraceRecordDMContext) {
            return this.createTraceRecordContext(targetDmc, "0");
        }
        if (ctx instanceof MITraceRecordDMContext) {
            String recordId = ((MITraceRecordDMContext)ctx).getRecordId();
            int recordIndex = Integer.parseInt(recordId);
            if (++recordIndex == this.fTraceRecordsStored) {
                recordIndex = 0;
            }
            return new MITraceRecordDMContext(this.getSession(), targetDmc, Integer.toString(recordIndex));
        }
        return null;
    }

    @Override
    public IGDBTraceControl.ITraceRecordDMContext createPrevRecordContext(IGDBTraceControl.ITraceRecordDMContext ctx) {
        if (ctx instanceof MITraceRecordDMContext) {
            IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IGDBTraceControl.ITraceTargetDMContext.class);
            String recordId = ((MITraceRecordDMContext)ctx).getRecordId();
            int recordIndex = Integer.parseInt(recordId);
            if (recordIndex == 0) {
                recordIndex = this.fTraceRecordsStored;
            }
            return new MITraceRecordDMContext(this.getSession(), targetDmc, Integer.toString(--recordIndex));
        }
        return null;
    }

    @Override
    public void getCurrentTraceRecordContext(IGDBTraceControl.ITraceTargetDMContext context, DataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext> drm) {
        if (this.fCurrentRecordDmc == null) {
            drm.setData((Object)new InvalidTraceRecordDMContext(this.getSession(), context));
        } else {
            drm.setData((Object)this.fCurrentRecordDmc);
        }
        drm.done();
    }

    @Override
    public void selectTraceRecord(final IGDBTraceControl.ITraceRecordDMContext context, final RequestMonitor rm) {
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (context instanceof MITraceRecordDMContext) {
            IGDBTraceControl.ITraceTargetDMContext targetDmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IGDBTraceControl.ITraceTargetDMContext.class);
            String recordId = ((MITraceRecordDMContext)context).getRecordId();
            int reference = Integer.parseInt(recordId);
            if (reference < 0) {
                this.stopTraceVisualization(targetDmc, rm);
                return;
            }
            this.fConnection.queueCommand(this.fCommandFactory.createMITraceFindFrameNumber(targetDmc, reference), (DataRequestMonitor)new DataRequestMonitor<MITraceFindInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (!((MITraceFindInfo)this.getData()).isFound()) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find trace record", null));
                        rm.done();
                        return;
                    }
                    GDBTraceControl_7_2.this.fCurrentRecordDmc = context;
                    GDBTraceControl_7_2.this.fTracepointIndexForTraceRecord = ((MITraceFindInfo)this.getData()).getTraceRecord().getTracepointId();
                    IMIProcesses procService = (IMIProcesses)GDBTraceControl_7_2.this.getServicesTracker().getService(IMIProcesses.class);
                    if (procService == null) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find necessary services", null));
                        rm.done();
                        return;
                    }
                    final MIResultRecord rr = ((MITraceFindInfo)this.getData()).getMIOutput().getMIResultRecord();
                    if (rr == null) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        rm.done();
                        return;
                    }
                    ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
                    procService.getProcessesBeingDebugged((IDMContext)controlDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)GDBTraceControl_7_2.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            if (!$assertionsDisabled && this.getData() == null) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && ((IDMContext[])this.getData()).length != 1) {
                                throw new AssertionError();
                            }
                            if (this.getData() == null || ((IDMContext[])this.getData()).length < 1) {
                                rm.done();
                                return;
                            }
                            IRunControl.IContainerDMContext processContainerDmc = (IRunControl.IContainerDMContext)((IDMContext[])this.getData())[0];
                            IMIProcesses procService = (IMIProcesses)GDBTraceControl_7_2.this.getServicesTracker().getService(IMIProcesses.class);
                            if (procService == null) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Could not find necessary services", null));
                                rm.done();
                                return;
                            }
                            procService.getProcessesBeingDebugged((IDMContext)processContainerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)GDBTraceControl_7_2.this.getExecutor(), rm){

                                protected void handleSuccess() {
                                    if (!$assertionsDisabled && this.getData() == null) {
                                        throw new AssertionError();
                                    }
                                    if (!$assertionsDisabled && ((IDMContext[])this.getData()).length != 1) {
                                        throw new AssertionError();
                                    }
                                    if (this.getData() == null || ((IDMContext[])this.getData()).length < 1) {
                                        rm.done();
                                        return;
                                    }
                                    IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IDMContext[])this.getData())[0];
                                    MITracepointSelectedEvent event = MITracepointSelectedEvent.parse(execDmc, rr.getToken(), rr.getMIResults());
                                    GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)event, GDBTraceControl_7_2.this.getProperties());
                                    rm.done();
                                }
                            });
                        }
                    });
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid trace record context.", null));
            rm.done();
        }
    }

    @Override
    public void stopTraceVisualization(final IGDBTraceControl.ITraceTargetDMContext context, final RequestMonitor rm) {
        if (!this.fIsTracingCurrentlySupported) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot stop visualizing for a post mortem session", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMITraceFindNone(context), (DataRequestMonitor)new DataRequestMonitor<MITraceFindInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (!$assertionsDisabled && ((MITraceFindInfo)this.getData()).isFound()) {
                    throw new AssertionError();
                }
                GDBTraceControl_7_2.this.fCurrentRecordDmc = null;
                InvalidTraceRecordDMContext invalidDmc = new InvalidTraceRecordDMContext(GDBTraceControl_7_2.this.getSession(), context);
                GDBTraceControl_7_2.this.getSession().dispatchEvent((Object)new TraceRecordSelectedChangedEvent(invalidDmc), GDBTraceControl_7_2.this.getProperties());
                rm.done();
            }
        });
    }

    @Override
    public void getTraceRecordData(final IGDBTraceControl.ITraceRecordDMContext context, DataRequestMonitor<IGDBTraceControl.ITraceRecordDMData> rm) {
        if (context instanceof MITraceRecordDMContext) {
            ImmediateRequestMonitor tdumpRm = new ImmediateRequestMonitor((RequestMonitor)rm, (DataRequestMonitor)rm){
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0);
                }

                protected void handleSuccess() {
                    GDBTraceControl_7_2.this.fConnection.queueCommand(GDBTraceControl_7_2.this.fCommandFactory.createCLITraceDump(context), (DataRequestMonitor)new DataRequestMonitor<CLITraceDumpInfo>((Executor)GDBTraceControl_7_2.this.getExecutor(), (RequestMonitor)this.val$rm){

                        protected void handleSuccess() {
                            TraceRecordDMData data = new TraceRecordDMData(((CLITraceDumpInfo)this.getData()).getContent(), ((CLITraceDumpInfo)this.getData()).getTracepointNumber(), ((CLITraceDumpInfo)this.getData()).getFrameNumber(), ((CLITraceDumpInfo)this.getData()).getTimestamp());
                            val$rm.setData((Object)data);
                            val$rm.done();
                        }
                    });
                }
            };
            if (this.fCurrentRecordDmc.equals(context)) {
                tdumpRm.done();
            } else {
                this.selectTraceRecord(context, (RequestMonitor)tdumpRm);
            }
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid trace record context.", null));
            rm.done();
        }
    }

    @Override
    public void setCircularTraceBuffer(final IGDBTraceControl.ITraceTargetDMContext context, boolean useCircularBuffer, final RequestMonitor rm) {
        if (context == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMIGDBSetCircularTraceBuffer(context, useCircularBuffer), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

            protected void handleSuccess() {
                GDBTraceControl_7_2.this.fTraceStatusCache.reset((IDMContext)context);
                rm.done();
            }
        });
    }

    @Override
    public void setDisconnectedTracing(final IGDBTraceControl.ITraceTargetDMContext context, boolean disconnectedTracing, final RequestMonitor rm) {
        if (context == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid context", null));
            return;
        }
        if (!this.fIsTracingCurrentlySupported) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Tracing not supported", null));
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMIGDBSetDisconnectedTracing(context, disconnectedTracing), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

            protected void handleSuccess() {
                GDBTraceControl_7_2.this.fTraceStatusCache.reset((IDMContext)context);
                rm.done();
            }
        });
    }

    @Override
    public void setTraceUser(IGDBTraceControl.ITraceTargetDMContext context, String userName, RequestMonitor rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, Messages.ErrorNotSupported, null));
    }

    @Override
    public void setTraceNotes(IGDBTraceControl.ITraceTargetDMContext context, String note, RequestMonitor rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, Messages.ErrorNotSupported, null));
    }

    public void flushCache(IDMContext context) {
        this.fTraceStatusCache.reset(context);
    }

    @Immutable
    protected static final class InvalidTraceRecordDMContext
    extends AbstractDMContext
    implements IGDBTraceControl.ITraceRecordDMContext {
        public InvalidTraceRecordDMContext(DsfSession session, IGDBTraceControl.ITraceTargetDMContext parent) {
            super(session.getId(), new IDMContext[]{parent});
        }

        @Override
        public String getRecordId() {
            return null;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        public String toString() {
            return this.baseToString() + ".noTraceRecord";
        }
    }

    @Immutable
    protected static final class MITraceRecordDMContext
    extends AbstractDMContext
    implements IGDBTraceControl.ITraceRecordDMContext {
        private final String fReference;

        public MITraceRecordDMContext(DsfSession session, IGDBTraceControl.ITraceTargetDMContext parent, String reference) {
            super(session.getId(), new IDMContext[]{parent});
            this.fReference = reference;
        }

        @Override
        public String getRecordId() {
            return this.fReference;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (this.fReference == null ? ((MITraceRecordDMContext)obj).fReference == null : this.fReference.equals(((MITraceRecordDMContext)obj).fReference));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fReference == null ? 0 : this.fReference.hashCode());
        }

        public String toString() {
            return this.baseToString() + ".reference(" + this.fReference + ")";
        }
    }

    private class TraceRecordDMData
    implements IGDBTraceControl.ITraceRecordDMData {
        private String fContent;
        private String fTracepointNum;
        private String fTimestamp;
        private String fFrameNumber;

        public TraceRecordDMData(String content, String tracepointNum, String frameNumber, String timestamp) {
            this.fContent = content;
            this.fTracepointNum = tracepointNum;
            this.fTimestamp = timestamp;
            this.fFrameNumber = frameNumber;
        }

        @Override
        public String getContent() {
            return this.fContent;
        }

        @Override
        public String getTracepointNumber() {
            return this.fTracepointNum;
        }

        @Override
        public String getRecordId() {
            return this.fFrameNumber;
        }

        @Override
        public String getTimestamp() {
            return this.fTimestamp;
        }
    }

    public static class TraceRecordSelectedChangedEvent
    extends AbstractDMEvent<IGDBTraceControl.ITraceRecordDMContext>
    implements IGDBTraceControl.ITraceRecordSelectedChangedDMEvent {
        final boolean fVisualModeEnabled;

        public TraceRecordSelectedChangedEvent(IGDBTraceControl.ITraceRecordDMContext context) {
            super((IDMContext)context);
            this.fVisualModeEnabled = !(context instanceof InvalidTraceRecordDMContext);
        }

        @Override
        public boolean isVisualizationModeEnabled() {
            return this.fVisualModeEnabled;
        }
    }

    private class TraceStatusDMData
    implements IGDBTraceControl.ITraceStatusDMData2 {
        private MITraceStatusInfo fInfo;

        public TraceStatusDMData(MITraceStatusInfo info) {
            this.fInfo = info;
        }

        public TraceStatusDMData() {
            this(null);
        }

        @Override
        public int getFreeBufferSize() {
            if (this.fInfo == null) {
                return 0;
            }
            return this.fInfo.getFreeBufferSize();
        }

        @Override
        public int getNumberOfCreatedFrames() {
            if (this.fInfo == null) {
                return 0;
            }
            return this.fInfo.getNumberOfCreatedFrames();
        }

        @Override
        public int getNumberOfCollectedFrame() {
            if (this.fInfo == null) {
                return 0;
            }
            return this.fInfo.getNumberOfCollectedFrame();
        }

        @Override
        public int getTotalBufferSize() {
            if (this.fInfo == null) {
                return 0;
            }
            return this.fInfo.getTotalBufferSize();
        }

        @Override
        public boolean isTracingActive() {
            if (this.fInfo == null) {
                return false;
            }
            return this.fInfo.isTracingActive();
        }

        @Override
        public boolean isTracingSupported() {
            return this.fInfo != null;
        }

        @Override
        public boolean isCircularBuffer() {
            if (this.fInfo == null) {
                return false;
            }
            return this.fInfo.isCircularBuffer();
        }

        @Override
        public boolean isTracingFromFile() {
            if (this.fInfo == null) {
                return false;
            }
            return this.fInfo.isTracingFromFile();
        }

        @Override
        public boolean isDisconnectedTracingEnabled() {
            if (this.fInfo == null) {
                return false;
            }
            return this.fInfo.isDisconnectedTracingEnabled();
        }

        @Override
        public IGDBTraceControl.STOP_REASON_ENUM getStopReason() {
            if (this.fInfo == null) {
                return null;
            }
            return this.fInfo.getStopReason();
        }

        @Override
        public Integer getStoppingTracepoint() {
            if (this.fInfo.getStopReason() == null) {
                return null;
            }
            return this.fInfo.getStopTracepoint();
        }

        @Override
        public String getUserName() {
            if (this.fInfo == null) {
                return "";
            }
            return this.fInfo.getUserName() == null ? "" : this.fInfo.getUserName();
        }

        @Override
        public String getNotes() {
            if (this.fInfo == null) {
                return "";
            }
            return this.fInfo.getNotes() == null ? "" : this.fInfo.getNotes();
        }

        @Override
        public String getStartTime() {
            if (this.fInfo == null) {
                return "";
            }
            return this.fInfo.getStartTime() == null ? "" : this.fInfo.getStartTime();
        }

        @Override
        public String getStopTime() {
            if (this.fInfo == null) {
                return "";
            }
            return this.fInfo.getStopTime() == null ? "" : this.fInfo.getStopTime();
        }

        @Override
        public String getStopErrorDescription() {
            if (this.getStopReason() != IGDBTraceControl.STOP_REASON_ENUM.ERROR) {
                return null;
            }
            return this.fInfo.getStopErrorDescription();
        }

        @Override
        public String getTraceFile() {
            if (!this.isTracingFromFile()) {
                return null;
            }
            return this.fInfo.getTraceFile();
        }

        @Override
        public String getCurrentTraceFrameId() {
            if (GDBTraceControl_7_2.this.fCurrentRecordDmc instanceof MITraceRecordDMContext) {
                return ((MITraceRecordDMContext)GDBTraceControl_7_2.this.fCurrentRecordDmc).getRecordId();
            }
            return null;
        }

        @Override
        public Integer getTracepointNumberForCurrentTraceFrame() {
            if (this.getCurrentTraceFrameId() != null) {
                return GDBTraceControl_7_2.this.fTracepointIndexForTraceRecord;
            }
            return null;
        }
    }

    private class TraceVariableDMData
    implements IGDBTraceControl.ITraceVariableDMData {
        private String fName;
        private String fValue;
        private String fInitialValue;

        public TraceVariableDMData(String name, String initial, String value) {
            this.fName = name;
            this.fInitialValue = initial;
            this.fValue = value;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getValue() {
            return this.fValue;
        }

        @Override
        public String getInitialValue() {
            return this.fInitialValue;
        }
    }

    private static class TracingStartedEvent
    extends AbstractDMEvent<IGDBTraceControl.ITraceTargetDMContext>
    implements IGDBTraceControl.ITracingStartedDMEvent {
        public TracingStartedEvent(IGDBTraceControl.ITraceTargetDMContext context) {
            super((IDMContext)context);
        }
    }

    private static class TracingStoppedEvent
    extends AbstractDMEvent<IGDBTraceControl.ITraceTargetDMContext>
    implements IGDBTraceControl.ITracingStoppedDMEvent {
        public TracingStoppedEvent(IGDBTraceControl.ITraceTargetDMContext context) {
            super((IDMContext)context);
        }
    }

    private static class TracingSupportedChangeEvent
    extends AbstractDMEvent<IGDBTraceControl.ITraceTargetDMContext>
    implements IGDBTraceControl.ITracingSupportedChangeDMEvent {
        private final boolean fTracingSupported;

        public TracingSupportedChangeEvent(IGDBTraceControl.ITraceTargetDMContext context, boolean supported) {
            super((IDMContext)context);
            this.fTracingSupported = supported;
        }

        @Override
        public boolean isTracingSupported() {
            return this.fTracingSupported;
        }
    }
}

