/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.language.settings.providers;

import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.ui.language.settings.providers.AbstractLanguageSettingProviderOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class GCCBuildCommandParserOptionPage
extends AbstractLanguageSettingProviderOptionPage {
    private boolean fEditable;
    private Text inputCommand;
    private Button expandRelativePathCheckBox;
    private Button scopeProjectRadioButton;
    private Button scopeFolderRadioButton;
    private Button scopeFileRadioButton;

    public void createControl(Composite parent) {
        this.fEditable = parent.isEnabled();
        AbstractBuildCommandParser provider = (AbstractBuildCommandParser)this.getProvider();
        Composite composite = new Composite(parent, 0);
        this.createCompositeForPageArea(composite);
        this.createCompilerPatternInputControl(provider, composite);
        this.createResourceScopeGroup(provider, composite);
        this.createResolvePathsCheckbox(composite, provider);
        this.setControl((Control)composite);
    }

    private void createCompositeForPageArea(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.marginRight = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
    }

    private void createCompilerPatternInputControl(AbstractBuildCommandParser provider, Composite composite) {
        Label label = ControlFactory.createLabel((Composite)composite, (String)Messages.GCCBuildCommandParserOptionPage_CompilerPattern);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setEnabled(this.fEditable);
        this.inputCommand = ControlFactory.createTextField((Composite)composite, (int)2052);
        String compilerPattern = provider.getCompilerPattern();
        this.inputCommand.setText(compilerPattern != null ? compilerPattern : "");
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.inputCommand.setLayoutData((Object)gd);
        this.inputCommand.setEnabled(this.fEditable);
        this.inputCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractBuildCommandParser provider;
                String text = GCCBuildCommandParserOptionPage.this.inputCommand.getText();
                if (!text.equals((provider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProvider()).getCompilerPattern())) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setCompilerPattern(text);
                    GCCBuildCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }
        });
    }

    private void createResolvePathsCheckbox(Composite composite, AbstractBuildCommandParser provider) {
        this.expandRelativePathCheckBox = new Button(composite, 32);
        this.expandRelativePathCheckBox.setText(Messages.GCCBuildCommandParserOptionPage_ResolvePaths);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.expandRelativePathCheckBox.setLayoutData((Object)gd);
        this.expandRelativePathCheckBox.setSelection(provider.isResolvingPaths());
        this.expandRelativePathCheckBox.setEnabled(this.fEditable);
        this.expandRelativePathCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildCommandParser provider;
                boolean enabled = GCCBuildCommandParserOptionPage.this.expandRelativePathCheckBox.getSelection();
                if (enabled != (provider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProvider()).isResolvingPaths()) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setResolvingPaths(enabled);
                    GCCBuildCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createResourceScopeGroup(AbstractBuildCommandParser provider, Composite composite) {
        Group resourceScopeGroup = new Group(composite, 0);
        resourceScopeGroup.setText(Messages.GCCBuildCommandParserOptionPage_ContainerForDiscoveredEntries);
        resourceScopeGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        resourceScopeGroup.setLayoutData((Object)gd);
        this.scopeFileRadioButton = new Button((Composite)resourceScopeGroup, 16);
        this.scopeFileRadioButton.setText(Messages.GCCBuildCommandParserOptionPage_File);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.scopeFileRadioButton.setLayoutData((Object)gd);
        this.scopeFileRadioButton.setSelection(provider.getResourceScope() == AbstractBuildCommandParser.ResourceScope.FILE);
        this.scopeFileRadioButton.setEnabled(this.fEditable);
        this.scopeFileRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildCommandParser provider;
                boolean enabled = GCCBuildCommandParserOptionPage.this.scopeFileRadioButton.getSelection();
                if (enabled != ((provider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProvider()).getResourceScope() == AbstractBuildCommandParser.ResourceScope.FILE)) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setResourceScope(AbstractBuildCommandParser.ResourceScope.FILE);
                    GCCBuildCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.scopeFolderRadioButton = new Button((Composite)resourceScopeGroup, 16);
        this.scopeFolderRadioButton.setText(Messages.GCCBuildCommandParserOptionPage_Folder);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.scopeFolderRadioButton.setLayoutData((Object)gd);
        this.scopeFolderRadioButton.setSelection(provider.getResourceScope() == AbstractBuildCommandParser.ResourceScope.FOLDER);
        this.scopeFolderRadioButton.setEnabled(this.fEditable);
        this.scopeFolderRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildCommandParser provider;
                boolean enabled = GCCBuildCommandParserOptionPage.this.scopeFolderRadioButton.getSelection();
                if (enabled != ((provider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProvider()).getResourceScope() == AbstractBuildCommandParser.ResourceScope.FOLDER)) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setResourceScope(AbstractBuildCommandParser.ResourceScope.FOLDER);
                    GCCBuildCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.scopeProjectRadioButton = new Button((Composite)resourceScopeGroup, 16);
        this.scopeProjectRadioButton.setText(Messages.GCCBuildCommandParserOptionPage_Project);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.scopeProjectRadioButton.setLayoutData((Object)gd);
        this.scopeProjectRadioButton.setSelection(provider.getResourceScope() == AbstractBuildCommandParser.ResourceScope.PROJECT);
        this.scopeProjectRadioButton.setEnabled(this.fEditable);
        this.scopeProjectRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBuildCommandParser provider;
                boolean enabled = GCCBuildCommandParserOptionPage.this.scopeProjectRadioButton.getSelection();
                if (enabled != ((provider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProvider()).getResourceScope() == AbstractBuildCommandParser.ResourceScope.PROJECT)) {
                    AbstractBuildCommandParser selectedProvider = (AbstractBuildCommandParser)GCCBuildCommandParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setResourceScope(AbstractBuildCommandParser.ResourceScope.PROJECT);
                    GCCBuildCommandParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }
}

