/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.debug.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.m2m.atl.debug.core.AtlDebugElement;
import org.eclipse.m2m.atl.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.debug.core.AtlThread;
import org.eclipse.m2m.atl.debug.core.AtlVariable;
import org.eclipse.m2m.atl.debug.core.adwp.ADWPDebugger;
import org.eclipse.m2m.atl.debug.core.adwp.AtlValue;
import org.eclipse.m2m.atl.debug.core.adwp.IntegerValue;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.StringValue;
import org.eclipse.m2m.atl.debug.core.adwp.Value;

public class AtlStackFrame
extends AtlDebugElement
implements IStackFrame {
    private ObjectReference stackFrame;
    private AtlThread thread;
    private int charStart = -1;
    private int charEnd = -1;
    private int location = -1;
    private String opName;
    private Map<String, AtlVariable> vars = new HashMap<String, AtlVariable>();
    private IFile sourcefile;

    public AtlStackFrame(AtlThread thread, ObjectReference stackFrame, AtlNbCharFile atlnbcharfile, IFile sourcefile) {
        super((AtlDebugTarget)thread.getDebugTarget());
        this.thread = thread;
        this.stackFrame = stackFrame;
        this.sourcefile = sourcefile;
        Value slv = stackFrame.call("getSourceLocation", Collections.emptyList());
        String sourceLocation = null;
        if (slv instanceof StringValue) {
            sourceLocation = ((StringValue)slv).getValue();
        }
        if (sourceLocation != null) {
            if (sourceLocation.matches(".*\\([0-9]*-[0-9]*\\)")) {
                String[] offsets = sourceLocation.substring(sourceLocation.indexOf(40) + 1, sourceLocation.lastIndexOf(41)).split("-");
                this.charStart = Integer.valueOf(offsets[0]);
                this.charEnd = Integer.valueOf(offsets[1]) + 1;
            } else {
                int[] sl = atlnbcharfile.getIndexChar(sourceLocation);
                this.charStart = sl[0];
                this.charEnd = sl[1];
            }
        }
        this.location = ((IntegerValue)stackFrame.call("getLocation", Collections.emptyList())).getValue();
        this.opName = ((StringValue)stackFrame.call("getOpName", Collections.emptyList())).getValue();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        ObjectReference lvs = (ObjectReference)this.stackFrame.call("getLocalVariables", Collections.emptyList());
        ObjectReference lvns = (ObjectReference)lvs.call("getKeys", Collections.emptyList());
        lvns = (ObjectReference)lvns.call("asSequence", Collections.emptyList());
        IntegerValue nblvs = (IntegerValue)lvns.call("size", Collections.emptyList());
        ArrayList<AtlVariable> atlVars = new ArrayList<AtlVariable>();
        int i = 1;
        while (i <= nblvs.getValue()) {
            block10: {
                String sname;
                AtlVariable atlVariable;
                AtlValue atlValue;
                StringValue name;
                block9: {
                    block8: {
                        name = (StringValue)lvns.call("at", Arrays.asList(IntegerValue.valueOf(i)));
                        Value value = lvs.call("get", Arrays.asList(name));
                        atlValue = new AtlValue(value, (AtlDebugTarget)this.thread.getDebugTarget());
                        if (!name.getValue().matches("^[0-9]*$")) break block8;
                        Value val = this.stackFrame.call("resolveVariableName", Arrays.asList(IntegerValue.valueOf(Integer.parseInt(name.getValue()))));
                        if (val instanceof StringValue) {
                            name = (StringValue)val;
                        }
                        break block9;
                    }
                    if (!((AtlDebugTarget)this.thread.getDebugTarget()).isDisassemblyMode()) break block10;
                }
                if ((atlVariable = this.vars.get(sname = name.toString())) == null) {
                    atlVariable = new AtlVariable(name.toString(), atlValue, (AtlDebugTarget)this.thread.getDebugTarget(), 0);
                    this.vars.put(sname, atlVariable);
                } else {
                    atlVariable.setValue(atlValue);
                }
                atlVars.add(atlVariable);
            }
            ++i;
        }
        return atlVars.toArray(new IVariable[0]);
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        int ret = -1;
        if (((AtlDebugTarget)this.thread.getDebugTarget()).isDisassemblyMode()) {
            ret = this.location + 1;
        }
        return ret;
    }

    public int getCharStart() throws DebugException {
        int ret = -1;
        if (!((AtlDebugTarget)this.thread.getDebugTarget()).isDisassemblyMode()) {
            ret = this.charStart;
        }
        return ret;
    }

    public int getCharEnd() throws DebugException {
        int ret = -1;
        if (!((AtlDebugTarget)this.thread.getDebugTarget()).isDisassemblyMode()) {
            ret = this.charEnd;
        }
        return ret;
    }

    public String getName() throws DebugException {
        String ret = null;
        ret = this.charStart == -1 || ((AtlDebugTarget)this.getDebugTarget()).isDisassemblyMode() ? String.valueOf(this.opName) + "() location: " + this.location : String.valueOf(this.opName) + "() location: " + this.charStart + ":" + this.charEnd;
        return ret;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    @Override
    public ILaunch getLaunch() {
        return this.thread.getLaunch();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IStorage getDisassembled() {
        StringBuffer ret = new StringBuffer();
        int k = 0;
        ADWPDebugger debugger = ((AtlDebugTarget)this.thread.getDebugTarget()).getDebugger();
        List<Value> l = debugger.requestMessage(20, Arrays.asList(this.stackFrame)).getArgs();
        Iterator<Value> i = l.iterator();
        while (i.hasNext()) {
            ret.append("<" + this.opName + "+" + k++ + ">\t" + i.next());
            ret.append("\n");
        }
        return new DisassemblyStorage("ATL#" + this.opName, ret.toString());
    }

    public ObjectReference getStackFrame() {
        return this.stackFrame;
    }

    public IFile getSourcefile() {
        return this.sourcefile;
    }

    private class DisassemblyStorage
    implements IStorage {
        private String contents;
        private String name;

        public DisassemblyStorage(String name, String contents) {
            this.contents = contents;
            this.name = name;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.contents.getBytes());
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return true;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }
}

