/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.oomph.version.ui.Activator;
import org.eclipse.oomph.version.ui.quickfixes.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractResolution
extends WorkbenchMarkerResolution {
    private IMarker marker;
    private String label;
    private String imageKey;

    public AbstractResolution(IMarker marker, String label, String imageKey) {
        this.marker = marker;
        this.label = label;
        this.imageKey = imageKey;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return "";
    }

    public final Image getImage() {
        ImageRegistry imageRegistry = Activator.getPlugin().getImageRegistry();
        return imageRegistry.get(this.imageKey);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                if (marker != this.marker && this.isApplicable(marker)) {
                    result.add(marker);
                }
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected abstract boolean isApplicable(IMarker var1) throws Exception;

    public void run(final IMarker[] markers, IProgressMonitor monitor) {
        new UIJob(Messages.AbstractResolution_jobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            AbstractResolution.super.run(markers, monitor);
                        }
                    }, monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
            }
        }.schedule();
    }

    public final void run(IMarker marker) {
        try {
            this.apply(marker);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    protected abstract void apply(IMarker var1) throws Exception;
}

