/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.model.signature;

import java.util.Optional;
import org.eclipse.passage.lic.base.NamedData;
import org.eclipse.passage.lic.licenses.model.api.Signature;
import org.eclipse.passage.lic.licenses.model.api.SignatureAttribute;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;

public abstract class SignatureData
implements NamedData<String> {
    private final Signature signature;

    protected SignatureData(Signature signature) {
        this.signature = signature;
    }

    public final Optional<String> get() {
        return this.attribute().map(SignatureAttribute::getValue);
    }

    private Optional<SignatureAttribute> attribute() {
        return this.signature.getAttributes().stream().filter(attr -> this.key().equals(attr.getName())).findAny();
    }

    public final void put(String value) {
        Optional<SignatureAttribute> attribute = this.attribute();
        if (!attribute.isPresent()) {
            attribute = Optional.of(LicensesFactory.eINSTANCE.createSignatureAttribute());
            attribute.get().setName(this.key());
            this.signature.getAttributes().add((Object)attribute.get());
        }
        attribute.get().setValue(value);
    }

    public static final class LicensingOperatorName
    extends SignatureData {
        public LicensingOperatorName(Signature signature) {
            super(signature);
        }

        public String key() {
            return "issuer.name";
        }
    }

    public static final class LicensingOperatorVersion
    extends SignatureData {
        public LicensingOperatorVersion(Signature signature) {
            super(signature);
        }

        public String key() {
            return "issuer.version";
        }
    }

    public static final class Of
    extends SignatureData {
        private final String name;

        public Of(String name, Signature signature) {
            super(signature);
            this.name = name;
        }

        public String key() {
            return this.name;
        }
    }

    public static final class OperatorLicensingStatus
    extends SignatureData {
        public OperatorLicensingStatus(Signature signature) {
            super(signature);
        }

        public String key() {
            return "issuer.licensing_status";
        }

        public void notRequired() {
            this.put("not_required");
        }

        public void sufficient() {
            this.put("sufficient");
        }

        public void insufficient() {
            this.put("insufficient");
        }
    }
}

